/*
 * Decompiled with CFR 0.152.
 */
package com.lambdatest.tunnel;

import com.lambdatest.KillPort;
import com.lambdatest.tunnel.TestDaemonThread1;
import com.lambdatest.tunnel.TunnelBinary;
import com.lambdatest.tunnel.TunnelException;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;

public class Tunnel {
    private static final List<String> IGNORE_KEYS = Arrays.asList("user", "key", "infoAPIPort", "binarypath", "load-balanced", "mitm", "pacfile", "mTLSHosts", "clientKey", "clientCert", "allowHosts", "verbose", "serverDomain", "usePrivateIp", "retry-proxy-error", "retry-proxy-error-count", "ntlm", "ntlmPassword", "ntlmUsername", "maxSSHConnections");
    private boolean tunnelFlag = false;
    private final int MAX_TUNNEL_STARTUP_RETRY_COUNT = 20;
    private final int TUNNEL_INITIAL_WAIT_AND_RETRY_BACKOFF = 3000;
    private final int HTTP_TIMEOUT = 5000;
    private final String TUNNEL_INFO_API = "/api/v1.0/info";
    private int infoAPIPortValue;
    private int tunnelID;
    private Map<String, String> parameters;
    private String userName;
    private String accessKey;
    private Integer tunnelCount = 0;
    TunnelBinary tunnelBinary;
    private Process process = null;
    private ReentrantLock mutex = new ReentrantLock();
    TestDaemonThread1 t1 = new TestDaemonThread1();

    public Tunnel() throws TunnelException {
        this.parameters = new HashMap<String, String>();
        this.parameters.put("bypassHosts", "--bypassHosts");
        this.parameters.put("callbackURL", "--callbackURL");
        this.parameters.put("config", "--config");
        this.parameters.put("controller", "--controller");
        this.parameters.put("egress-only ", "--egress-only ");
        this.parameters.put("dir", "--dir");
        this.parameters.put("dns", "--dns");
        this.parameters.put("emulateChrome", "--emulateChrome");
        this.parameters.put("env", "--env");
        this.parameters.put("help", "--help");
        this.parameters.put("infoAPIPort", "--infoAPIPort");
        this.parameters.put("ingress-only", "--ingress-only");
        this.parameters.put("key", "--key");
        this.parameters.put("localDomains", "--local-domains");
        this.parameters.put("logFile", "--logFile");
        this.parameters.put("mode", "--mode");
        this.parameters.put("noProxy", "--no-proxy");
        this.parameters.put("pidfile", "--pidfile");
        this.parameters.put("port", "--port");
        this.parameters.put("proxyHost", "--proxy-host");
        this.parameters.put("proxyPass", "--proxy-pass");
        this.parameters.put("proxyPort", "--proxy-port");
        this.parameters.put("proxyUser", "--proxy-user");
        this.parameters.put("sharedTunnel", "--shared-tunnel");
        this.parameters.put("sshConnType", "--sshConnType");
        this.parameters.put("tunnelName", "--tunnelName");
        this.parameters.put("user", "--user");
        this.parameters.put("load-balanced", "--load-balanced");
        this.parameters.put("v", "--v");
        this.parameters.put("version", "--version");
        this.parameters.put("basicAuth", "--basic-auth");
        this.parameters.put("mitm", "--mitm");
        this.parameters.put("skip-upgrade", "--skip-upgrade");
        this.parameters.put("pacfile", "--pacfile");
        this.parameters.put("mTLSHosts", "--mTLSHosts");
        this.parameters.put("clientKey", "--clientKey");
        this.parameters.put("clientCert", "--clientCert");
        this.parameters.put("allowHosts", "--allowHosts");
        this.parameters.put("verbose", "--verbose");
        this.parameters.put("serverDomain", "--server-domain");
        this.parameters.put("usePrivateIp", "--use-private-ip");
        this.parameters.put("retry-proxy-error", "--retry-proxy-error");
        this.parameters.put("retry-proxy-error-count", "--retry-proxy-error-count");
        this.parameters.put("ntlm", "--ntlm");
        this.parameters.put("ntlmUsername", "--ntlm-username");
        this.parameters.put("ntlmPassword", "--ntlm-password");
        this.parameters.put("maxSSHConnections", "--maxSSHConnections");
    }

    public synchronized Boolean start(Map<String, String> options) {
        try {
            this.tunnelBinary = new TunnelBinary(options.get("binary"));
            this.mutex.lock();
            this.infoAPIPortValue = options.containsKey("infoAPIPort") && options.get("infoAPIPort").matches("^[0-9]+") ? Integer.parseInt(options.get("infoAPIPort")) : Tunnel.findAvailablePort();
            this.t1.setDaemon(true);
            this.t1.start();
            Tunnel.clearTheFile();
            this.verifyTunnelCredentials(options);
            System.out.println("tunnel Verified");
            if (options.get("load-balanced") != "" && options.get("load-balanced") != null && (options.get("tunnelName") == "" || options.get("tunnelName") == null)) {
                options.put("tunnelName", "Maven_Tunnel_LambdaTest_" + options.get("key"));
            }
            try {
                for (int i = 0; i < 5; ++i) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
            this.userName = options.get("user");
            this.accessKey = options.get("key");
            String tunnelBinaryPath = "";
            if (options.get("binary") != null) {
                tunnelBinaryPath = tunnelBinaryPath + options.get("binary");
            } else {
                Tunnel tunnel = this;
                String path = tunnel.tunnelBinary.getBinaryPath();
                tunnelBinaryPath = tunnelBinaryPath + path;
            }
            boolean isWhiteSpaceInBinaryPath = tunnelBinaryPath.contains(" ");
            if (isWhiteSpaceInBinaryPath) {
                String[] command = this.passParametersToTunnelV2(options);
                this.runCommandV2(command);
            } else {
                String command = this.passParametersToTunnel(options);
                this.runCommand(command);
            }
            this.mutex.unlock();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void verifyTunnelCredentials(Map<String, String> options) throws TunnelException {
        if (options.get("user") == null || options.get("user") == "" || options.get("key") == null || options.get("key") == "") {
            this.tunnelFlag = false;
            throw new TunnelException("Username/AccessKey Cannot Be Empty");
        }
    }

    public synchronized void stop() throws Exception {
        if (!this.tunnelFlag) {
            return;
        }
        this.mutex.lock();
        this.stopTunnel();
        boolean hasTerminated = this.process.waitFor(30L, TimeUnit.SECONDS);
        if (!hasTerminated) {
            System.err.println("The tunnel process did not terminate within timeout");
            this.process.destroyForcibly();
        } else {
            System.out.println("Tunnel process terminated successfully.");
        }
        this.mutex.unlock();
    }

    private static Integer findAvailablePort() throws IOException {
        ServerSocket s = new ServerSocket(0);
        s.close();
        return s.getLocalPort();
    }

    public static void clearTheFile() throws IOException {
        FileWriter fwOb = new FileWriter("tunnel.log", false);
        PrintWriter pwOb = new PrintWriter((Writer)fwOb, false);
        pwOb.flush();
        pwOb.close();
        fwOb.close();
    }

    public void stopTunnel() throws TunnelException {
        try {
            String filePath;
            Path pathOfFile;
            block23: {
                boolean stopTunnelAPI = Boolean.parseBoolean(System.getenv("STOP_TUNNEL_API"));
                String deleteEndpoint = stopTunnelAPI ? "https://ts.lambdatest.com/v1.0/stop/" + this.tunnelID : "http://127.0.0.1:" + String.valueOf(this.infoAPIPortValue) + "/api/v1.0/stop";
                HttpDelete httpDelete = new HttpDelete(deleteEndpoint);
                if (!stopTunnelAPI) {
                    try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpDelete);
                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                        if (response.getStatusLine().getStatusCode() != 200) {
                            throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
                        }
                        break block23;
                    }
                }
                String auth = this.userName + ":" + this.accessKey;
                String encodedAuth = "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
                try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                    httpDelete.setHeader("Authorization", encodedAuth);
                    int attempt = 0;
                    CloseableHttpResponse response = null;
                    while (attempt < 3) {
                        response = httpClient.execute((HttpUriRequest)httpDelete);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            System.out.println("Tunnel stopped successfully");
                            break;
                        }
                        ++attempt;
                        if (response != null) {
                            response.close();
                        }
                        if (attempt == 3) {
                            System.out.println("Max retries reached, could not stop tunnel");
                            throw new TunnelException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
                        }
                        Thread.sleep(3000L);
                    }
                }
            }
            if (!Files.exists(pathOfFile = Paths.get(filePath = ".lambdatest/tunnelprocs/" + this.t1.port + ".txt", new String[0]), new LinkOption[0])) {
                System.out.println("File does not exist, cannot stop tunnel");
                return;
            }
            boolean result = Files.deleteIfExists(pathOfFile);
            if (result) {
                System.out.println("File is deleted");
            } else {
                System.out.println("File does not exists");
            }
            KillPort killPort = new KillPort();
            KillPort.killProcess(this.t1.port);
            System.out.println("Tunnel closed successfully && Port process killed");
        }
        catch (Exception e) {
            throw new TunnelException("Tunnel with ID: " + this.tunnelID + " has been closed!");
        }
    }

    public String passParametersToTunnel(Map<String, String> options) {
        String command = "";
        if (options.get("binary") != null) {
            command = command + options.get("binary");
        } else {
            Tunnel tunnel = this;
            String binaryPath = tunnel.tunnelBinary.getBinaryPath();
            command = command + binaryPath;
        }
        command = command + " --user ";
        if (options.get("user") != null) {
            command = command + options.get("user");
        }
        command = command + " --key ";
        if (options.get("key") != null) {
            command = command + options.get("key");
        }
        command = command + " --infoAPIPort ";
        command = command + String.valueOf(this.infoAPIPortValue);
        if (options.get("load-balanced") != "" && options.get("load-balanced") != null) {
            command = command + " --load-balanced ";
        }
        if (options.get("skip-upgrade") != "" && options.get("skip-upgrade") != null) {
            command = command + " --skip-upgrade ";
        }
        if (options.get("basicAuth") != "" && options.get("basicAuth") != null) {
            command = command + " --basic-auth ";
            command = command + options.get("basicAuth");
        }
        if (options.get("mitm") != "" && options.get("mitm") != null) {
            command = command + " --mitm ";
        }
        if (options.get("pacfile") != "" && options.get("pacfile") != null) {
            command = command + " --pacfile ";
            command = command + options.get("pacfile");
        }
        if (options.get("mTLSHosts") != "" && options.get("mTLSHosts") != null) {
            command = command + " --mTLSHosts ";
            command = command + options.get("mTLSHosts");
        }
        if (options.get("clientKey") != "" && options.get("clientKey") != null) {
            command = command + " --clientKey ";
            command = command + options.get("clientKey");
        }
        if (options.get("clientCert") != "" && options.get("clientCert") != null) {
            command = command + " --clientCert ";
            command = command + options.get("clientCert");
        }
        if (options.get("allowHosts") != "" && options.get("allowHosts") != null) {
            command = command + " --allowHosts ";
            command = command + options.get("allowHosts");
        }
        if (options.get("serverDomain") != "" && options.get("serverDomain") != null) {
            command = command + " --server-domain ";
            command = command + options.get("serverDomain");
        }
        if (options.get("verbose") != "" && options.get("verbose") != null) {
            command = command + " --verbose ";
        }
        if (options.get("usePrivateIp") != "" && options.get("usePrivateIp") != null) {
            command = command + " --use-private-ip ";
        }
        if (options.get("retry-proxy-error") != "" && options.get("retry-proxy-error") != null) {
            command = command + " --retry-proxy-error ";
        }
        if (options.get("retry-proxy-error-count") != "" && options.get("retry-proxy-error-count") != null) {
            command = command + " --retry-proxy-error-count ";
            command = command + options.get("retry-proxy-error-count");
        }
        if (options.get("ntlm") != "" && options.get("ntlm") != null) {
            command = command + " --ntlm ";
        }
        if (options.get("ntlmUsername") != "" && options.get("ntlmUsername") != null) {
            command = command + " --ntlm-username ";
            command = command + options.get("ntlmUsername");
        }
        if (options.get("ntlmPassword") != "" && options.get("ntlmPassword") != null) {
            command = command + " --ntlm-password ";
            command = command + options.get("ntlmPassword");
        }
        if (options.get("maxSSHConnections") != "" && options.get("maxSSHConnections") != null) {
            command = command + " --maxSSHConnections ";
            command = command + options.get("maxSSHConnections");
        }
        if (options.get("logLevel") != "" && options.get("logLevel") != null) {
            command = command + " --log-level ";
            command = command + options.get("logLevel");
        }
        if (this.t1.port != null) {
            command = command + " --callbackURL http://127.0.0.1:" + String.valueOf(this.t1.port);
        }
        for (Map.Entry<String, String> opt : options.entrySet()) {
            String parameter = opt.getKey().trim();
            if (IGNORE_KEYS.contains(parameter) || this.parameters.get(parameter) == null) continue;
            command = command + " " + this.parameters.get(parameter) + " ";
            if (opt.getValue() == null) continue;
            command = command + opt.getValue().trim();
        }
        return command;
    }

    public String[] passParametersToTunnelV2(Map<String, String> options) {
        ArrayList<String> commandArray = new ArrayList<String>();
        if (options.get("binary") != null) {
            commandArray.add(options.get("binary"));
        } else {
            Tunnel tunnel = this;
            commandArray.add(tunnel.tunnelBinary.getBinaryPath());
        }
        commandArray.add("--user");
        if (options.get("user") != null) {
            commandArray.add(options.get("user"));
        }
        commandArray.add("--key");
        if (options.get("key") != null) {
            commandArray.add(options.get("key"));
        }
        commandArray.add("--infoAPIPort");
        commandArray.add(String.valueOf(this.infoAPIPortValue));
        if (options.get("load-balanced") != "" && options.get("load-balanced") != null) {
            commandArray.add("--load-balanced");
        }
        if (options.get("skip-upgrade") != "" && options.get("skip-upgrade") != null) {
            commandArray.add("--skip-upgrade");
        }
        if (options.get("basicAuth") != "" && options.get("basicAuth") != null) {
            commandArray.add("--basic-auth");
            commandArray.add(options.get("basicAuth"));
        }
        if (options.get("mitm") != "" && options.get("mitm") != null) {
            commandArray.add("--mitm");
        }
        if (options.get("pacfile") != "" && options.get("pacfile") != null) {
            commandArray.add("--pacfile");
            commandArray.add(options.get("pacfile"));
        }
        if (options.get("mTLSHosts") != "" && options.get("mTLSHosts") != null) {
            commandArray.add("--mTLSHosts");
            commandArray.add(options.get("mTLSHosts"));
        }
        if (options.get("clientKey") != "" && options.get("clientKey") != null) {
            commandArray.add("--clientKey");
            commandArray.add(options.get("clientKey"));
        }
        if (options.get("clientCert") != "" && options.get("clientCert") != null) {
            commandArray.add("--clientCert");
            commandArray.add(options.get("clientCert"));
        }
        if (options.get("allowHosts") != "" && options.get("allowHosts") != null) {
            commandArray.add("--allowHosts");
            commandArray.add(options.get("allowHosts"));
        }
        if (options.get("serverDomain") != "" && options.get("serverDomain") != null) {
            commandArray.add("--server-domain");
            commandArray.add(options.get("serverDomain"));
        }
        if (options.get("verbose") != "" && options.get("verbose") != null) {
            commandArray.add("--verbose");
        }
        if (options.get("usePrivateIp") != "" && options.get("usePrivateIp") != null) {
            commandArray.add("--use-private-ip");
        }
        if (options.get("retry-proxy-error") != "" && options.get("retry-proxy-error") != null) {
            commandArray.add("--retry-proxy-error");
        }
        if (options.get("retry-proxy-error-count") != "" && options.get("retry-proxy-error-count") != null) {
            commandArray.add("--retry-proxy-error-count");
            commandArray.add(options.get("retry-proxy-error-count"));
        }
        if (options.get("ntlm") != "" && options.get("ntlm") != null) {
            commandArray.add("--ntlm");
        }
        if (options.get("ntlmUsername") != "" && options.get("ntlmUsername") != null) {
            commandArray.add("--ntlm-username");
            commandArray.add(options.get("ntlmUsername"));
        }
        if (options.get("ntlmPassword") != "" && options.get("ntlmPassword") != null) {
            commandArray.add("--ntlm-password");
            commandArray.add(options.get("ntlmPassword"));
        }
        if (options.get("maxSSHConnections") != "" && options.get("maxSSHConnections") != null) {
            commandArray.add("--maxSSHConnections");
            commandArray.add(options.get("maxSSHConnections"));
        }
        if (options.get("logLevel") != "" && options.get("logLevel") != null) {
            commandArray.add("--log-level");
            commandArray.add(options.get("logLevel"));
        }
        if (this.t1.port != null) {
            commandArray.add("--callbackURL");
            commandArray.add("http://127.0.0.1:" + String.valueOf(this.t1.port));
        }
        for (Map.Entry<String, String> opt : options.entrySet()) {
            String parameter = opt.getKey().trim();
            if (IGNORE_KEYS.contains(parameter) || this.parameters.get(parameter) == null) continue;
            commandArray.add(this.parameters.get(parameter));
            if (opt.getValue() == null) continue;
            commandArray.add(opt.getValue().trim());
        }
        String[] commandV2 = commandArray.toArray(new String[commandArray.size()]);
        return commandV2;
    }

    public void runCommand(String command) throws IOException {
        try {
            long start;
            Runtime run = Runtime.getRuntime();
            this.process = run.exec(command);
            Boolean update = false;
            long end = start = System.currentTimeMillis();
            this.waitForTunnelToStart();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void runCommandV2(String[] command) throws IOException {
        try {
            Runtime run = Runtime.getRuntime();
            this.process = run.exec(command);
            Boolean update = false;
            this.waitForTunnelToStart();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void waitForTunnelToStart() throws IOException {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(5000).build();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            for (int retryCount = 0; retryCount < 20; ++retryCount) {
                try {
                    Thread.sleep(3000L);
                    System.out.println("Checking Tunnel Status");
                    String infoAPIGetEndpoint = "http://127.0.0.1:" + Integer.toString(this.infoAPIPortValue) + "/api/v1.0/info";
                    HttpGet httpGet = new HttpGet(infoAPIGetEndpoint);
                    try (CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpGet);){
                        if (execute.getStatusLine().getStatusCode() == 200) {
                            String line;
                            System.out.println("Received Tunnel Status Response");
                            BufferedReader reader = new BufferedReader(new InputStreamReader(execute.getEntity().getContent()));
                            StringBuilder response = new StringBuilder();
                            while ((line = reader.readLine()) != null) {
                                response.append(line);
                            }
                            JSONObject tunnelInfo = new JSONObject(response.toString());
                            if (tunnelInfo.getString("status").equals("SUCCESS")) {
                                this.tunnelFlag = true;
                                System.out.println("Tunnel Started Successfully");
                                if (tunnelInfo.getJSONObject("data") != null && tunnelInfo.getJSONObject("data").has("id")) {
                                    this.tunnelID = tunnelInfo.getJSONObject("data").getInt("id");
                                }
                                System.out.println("Tunnel ID: " + this.tunnelID);
                                break;
                            }
                            System.out.println("Tunnel Status: " + tunnelInfo.getString("status"));
                            continue;
                        }
                        System.out.println("Tunnel Status Response: " + execute.getStatusLine().getStatusCode());
                        continue;
                    }
                }
                catch (Exception e) {
                    System.out.println("Tunnel not yet started. Retrying");
                }
            }
        }
    }
}

