/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.exceptions.EmbeddedRedisException;

abstract class AbstractRedisInstance {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisInstance.class);
    private List<String> arguments;
    private Process redisProcess;
    private volatile Boolean active = Boolean.FALSE;
    private ExecutorService executor;

    AbstractRedisInstance(List<String> args) {
        this.arguments = new LinkedList<String>(args);
        log.debug("args: {}", this.arguments);
    }

    public Boolean isActive() {
        return this.active;
    }

    public void doStart() throws EmbeddedRedisException {
        if (this.active.booleanValue()) {
            String msg = "This redis instance is already running...";
            log.warn(msg);
            throw new EmbeddedRedisException(msg);
        }
        try {
            this.redisProcess = this.createRedisProcessBuilder().start();
            this.installExitHook();
            this.logStandardError();
            this.awaitRedisInstanceReady();
            this.active = Boolean.TRUE;
        }
        catch (IOException e) {
            String msg = "Failed to start Redis instance";
            log.warn("{}. exception: {}", new Object[]{msg, e.getMessage(), e});
            throw new EmbeddedRedisException(msg, e);
        }
    }

    public void installExitHook() {
        String name = "RedisInstanceCleaner";
        Runtime.getRuntime().addShutdownHook(new Thread(this::doStop, name));
    }

    public void logStandardError() {
        InputStream errorStream = this.redisProcess.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));
        PrintReaderRunnable printReaderTask = new PrintReaderRunnable(reader);
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(printReaderTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitRedisInstanceReady() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.redisProcess.getInputStream()));
        try {
            String outputLine;
            StringBuilder outputStringBuffer = new StringBuilder();
            do {
                if ((outputLine = reader.readLine()) == null) {
                    String msg = "Can't start redis instance. Check logs for details. Redis process log: " + String.valueOf(outputStringBuffer);
                    log.warn(msg);
                    throw new RuntimeException(msg);
                }
                outputStringBuffer.append("\n");
                outputStringBuffer.append(outputLine);
                log.debug(outputLine);
            } while (!outputLine.matches(this.redisInstanceReadyPattern()));
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader, null);
        }
    }

    protected abstract String redisInstanceReadyPattern();

    public ProcessBuilder createRedisProcessBuilder() {
        File executable = new File(this.arguments.getFirst());
        ProcessBuilder pb = new ProcessBuilder(this.arguments);
        pb.directory(executable.getParentFile());
        return pb;
    }

    public synchronized void doStop() throws EmbeddedRedisException {
        if (this.active.booleanValue()) {
            if (this.executor != null && !this.executor.isShutdown()) {
                this.executor.shutdown();
            }
            this.redisProcess.destroy();
            this.tryWaitFor();
            this.active = Boolean.FALSE;
        }
    }

    public void tryWaitFor() {
        try {
            this.redisProcess.waitFor();
        }
        catch (InterruptedException e) {
            String msg = "Failed to stop redis instance";
            log.warn("{}. exception: {}", new Object[]{msg, e.getMessage(), e});
            throw new EmbeddedRedisException(msg, e);
        }
    }

    @Generated
    public AbstractRedisInstance() {
    }

    @Generated
    public List<String> getArguments() {
        return this.arguments;
    }

    private static class PrintReaderRunnable
    implements Runnable {
        private final BufferedReader reader;

        @Override
        public void run() {
            try {
                this.readLines();
            }
            finally {
                IOUtils.closeQuietly((Closeable)this.reader, null);
            }
        }

        public void readLines() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    log.info(line);
                }
            }
            catch (IOException e) {
                log.warn("Failed to readLines. exception: {}", (Object)e.getMessage(), (Object)e);
            }
        }

        @Generated
        private PrintReaderRunnable(BufferedReader reader) {
            this.reader = reader;
        }
    }
}

