/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.AbstractRedisInstance;
import redis.embedded.IRedisServer;
import redis.embedded.exceptions.EmbeddedRedisException;

abstract class AbstractRedisServerInstance
extends AbstractRedisInstance
implements IRedisServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisServerInstance.class);
    private final Set<Integer> ports = Sets.newHashSet();
    private final Set<Integer> sentinelPorts = Sets.newHashSet();
    private final Set<Integer> masterPorts = Sets.newHashSet();

    AbstractRedisServerInstance(List<String> args) {
        super(args);
    }

    protected AbstractRedisServerInstance(Integer port) {
        this.ports.add(port);
    }

    AbstractRedisServerInstance(List<String> args, Integer port) {
        super(args);
        this.ports.add(port);
    }

    AbstractRedisServerInstance(Integer sentinelPort, Integer masterPort) {
        this.ports.add(sentinelPort);
        this.ports.add(masterPort);
        this.sentinelPorts.add(sentinelPort);
        this.masterPorts.add(masterPort);
    }

    AbstractRedisServerInstance(List<String> args, Integer sentinelPort, Integer masterPort) {
        super(args);
        this.ports.add(sentinelPort);
        this.ports.add(masterPort);
        this.sentinelPorts.add(sentinelPort);
        this.masterPorts.add(masterPort);
    }

    @Override
    public synchronized void start() throws EmbeddedRedisException {
        this.doStart();
    }

    @Override
    public synchronized void stop() throws EmbeddedRedisException {
        this.doStop();
    }

    protected abstract String redisServerReadyPattern();

    @Override
    public String redisInstanceReadyPattern() {
        return this.redisServerReadyPattern();
    }

    @Override
    public Set<Integer> ports() {
        return this.ports;
    }

    public Set<Integer> sentinelPorts() {
        return this.sentinelPorts;
    }

    public Set<Integer> masterPorts() {
        return this.masterPorts;
    }
}

