/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.collect.Lists;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import redis.embedded.AbstractRedisInstance;
import redis.embedded.AbstractRedisServerInstance;
import redis.embedded.IRedisServer;
import redis.embedded.RedisBunchBuilder;
import redis.embedded.RedisSentinel;
import redis.embedded.RedisServer;
import redis.embedded.exceptions.EmbeddedRedisException;

public class RedisBunch
implements IRedisServer {
    private final List<RedisSentinel> redisSentinels = new LinkedList<RedisSentinel>();
    private final List<RedisServer> redisServers = new LinkedList<RedisServer>();

    RedisBunch(List<RedisSentinel> redisSentinels, List<RedisServer> redisServers) {
        this.redisSentinels.addAll(redisSentinels);
        this.redisServers.addAll(redisServers);
    }

    public static RedisBunchBuilder builder() {
        return new RedisBunchBuilder();
    }

    @Override
    public Boolean isActive() {
        return this.redisSentinels.stream().allMatch(AbstractRedisInstance::isActive) && this.redisServers.stream().allMatch(AbstractRedisInstance::isActive);
    }

    @Override
    public void start() throws EmbeddedRedisException {
        ((Stream)this.redisSentinels.stream().parallel()).forEach(AbstractRedisServerInstance::start);
        ((Stream)this.redisServers.stream().parallel()).forEach(AbstractRedisServerInstance::start);
    }

    @Override
    public void stop() throws EmbeddedRedisException {
        ((Stream)this.redisSentinels.stream().parallel()).forEach(AbstractRedisServerInstance::stop);
        ((Stream)this.redisServers.stream().parallel()).forEach(AbstractRedisServerInstance::stop);
    }

    @Override
    public Set<Integer> ports() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>();
        ports.addAll(this.sentinelPorts());
        ports.addAll(this.serverPorts());
        return ports;
    }

    public List<RedisSentinel> sentinels() {
        return Lists.newLinkedList(this.redisSentinels);
    }

    public Set<Integer> sentinelPorts() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>();
        this.redisSentinels.forEach(redisSentinel -> ports.addAll(redisSentinel.ports()));
        return ports;
    }

    public List<RedisServer> servers() {
        return Lists.newLinkedList(this.redisServers);
    }

    public Set<Integer> serverPorts() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>();
        this.redisServers.forEach(redisServer -> ports.addAll(redisServer.ports()));
        return ports;
    }
}

