/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import redis.embedded.PortProvider;
import redis.embedded.RedisBunch;
import redis.embedded.RedisSentinel;
import redis.embedded.RedisSentinelBuilder;
import redis.embedded.RedisServer;
import redis.embedded.RedisServerBuilder;
import redis.embedded.common.CommonConstant;
import redis.embedded.ports.EphemeralPortProvider;
import redis.embedded.ports.PredefinedPortProvider;
import redis.embedded.ports.SequencePortProvider;

public class RedisBunchBuilder {
    private final List<ReplicationGroup> groups = new LinkedList<ReplicationGroup>();
    private RedisSentinelBuilder sentinelBuilder = new RedisSentinelBuilder();
    private RedisServerBuilder serverBuilder = new RedisServerBuilder();
    private Integer sentinelCount = 1;
    private Integer quorumSize = 1;
    private PortProvider sentinelPortProvider = new SequencePortProvider(CommonConstant.DEFAULT_REDIS_SENTINEL_PORT);
    private PortProvider replicationGroupPortProvider = new SequencePortProvider(CommonConstant.DEFAULT_REDIS_PORT);

    public RedisBunchBuilder withSentinelBuilder(RedisSentinelBuilder sentinelBuilder) {
        this.sentinelBuilder = sentinelBuilder;
        return this;
    }

    public RedisBunchBuilder withServerBuilder(RedisServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    public RedisBunchBuilder sentinelPorts(Set<Integer> ports) {
        this.sentinelPortProvider = new PredefinedPortProvider(ports);
        this.sentinelCount = ports.size();
        return this;
    }

    public RedisBunchBuilder serverPorts(Set<Integer> ports) {
        this.replicationGroupPortProvider = new PredefinedPortProvider(ports);
        return this;
    }

    public RedisBunchBuilder ephemeralSentinels() {
        this.sentinelPortProvider = new EphemeralPortProvider();
        return this;
    }

    public RedisBunchBuilder ephemeralServers() {
        this.replicationGroupPortProvider = new EphemeralPortProvider();
        return this;
    }

    public RedisBunchBuilder ephemeral() {
        this.ephemeralSentinels();
        this.ephemeralServers();
        return this;
    }

    public RedisBunchBuilder sentinelCount(Integer sentinelCount) {
        this.sentinelCount = sentinelCount;
        return this;
    }

    public RedisBunchBuilder sentinelStartingPort(Integer startingPort) {
        this.sentinelPortProvider = new SequencePortProvider(startingPort);
        return this;
    }

    public RedisBunchBuilder quorumSize(Integer quorumSize) {
        this.quorumSize = quorumSize;
        return this;
    }

    public RedisBunchBuilder replicationGroup(String masterName, Integer slaveCount) {
        this.groups.add(new ReplicationGroup(masterName, slaveCount, this.replicationGroupPortProvider));
        return this;
    }

    public RedisBunch build() {
        List<RedisSentinel> redisSentinels = this.buildSentinels();
        List<RedisServer> redisServers = this.buildServers();
        return new RedisBunch(redisSentinels, redisServers);
    }

    private List<RedisServer> buildServers() {
        LinkedList<RedisServer> redisServers = new LinkedList<RedisServer>();
        this.groups.forEach(group -> {
            redisServers.add(this.buildMaster((ReplicationGroup)group));
            redisServers.addAll(this.buildSlaves((ReplicationGroup)group));
        });
        return redisServers;
    }

    private List<RedisServer> buildSlaves(ReplicationGroup group) {
        LinkedList<RedisServer> redisServers = new LinkedList<RedisServer>();
        group.slavePorts.forEach(slavePort -> {
            this.serverBuilder.reset();
            this.serverBuilder.port((Integer)slavePort);
            this.serverBuilder.replicaOf(group.masterPort);
            RedisServer slave = this.serverBuilder.build();
            redisServers.add(slave);
        });
        return redisServers;
    }

    private RedisServer buildMaster(ReplicationGroup group) {
        this.serverBuilder.reset();
        RedisServer master = this.serverBuilder.port(group.masterPort).build();
        return master;
    }

    private List<RedisSentinel> buildSentinels() {
        Integer toBuild = this.sentinelCount;
        LinkedList<RedisSentinel> redisSentinels = new LinkedList<RedisSentinel>();
        while (true) {
            Integer n = toBuild;
            toBuild = toBuild - 1;
            if (n <= 0) break;
            redisSentinels.add(this.buildSentinel());
        }
        return redisSentinels;
    }

    private RedisSentinel buildSentinel() {
        this.sentinelBuilder.reset();
        this.sentinelBuilder.sentinelPort(this.nextSentinelPort());
        this.groups.forEach(group -> {
            this.sentinelBuilder.masterName(group.masterName);
            this.sentinelBuilder.masterPort(group.masterPort);
            this.sentinelBuilder.quorumSize(this.quorumSize);
            this.sentinelBuilder.addDefaultReplicationGroup();
        });
        return this.sentinelBuilder.build();
    }

    private Integer nextSentinelPort() {
        return this.sentinelPortProvider.next();
    }

    @Generated
    public RedisBunchBuilder() {
    }

    private static class ReplicationGroup {
        private final String masterName;
        private final Integer masterPort;
        private final Set<Integer> slavePorts = new LinkedHashSet<Integer>();

        private ReplicationGroup(String masterName, Integer slaveCount, PortProvider portProvider) {
            this.masterName = masterName;
            this.masterPort = portProvider.next();
            while (true) {
                Integer n = slaveCount;
                slaveCount = slaveCount - 1;
                if (n <= 0) break;
                this.slavePorts.add(portProvider.next());
            }
        }
    }
}

