/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.RedisCliExecProvider;
import redis.embedded.RedisClient;
import redis.embedded.RedisExecProvider;
import redis.embedded.exceptions.RedisBuildingException;

public class RedisClientBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisClientBuilder.class);
    private final Collection<Integer> ports = new LinkedList<Integer>();
    private File executable;
    private RedisExecProvider redisExecProvider = RedisCliExecProvider.defaultProvider();
    private Integer clusterReplicas = 0;

    public RedisClientBuilder redisExecProvider(RedisExecProvider redisExecProvider) {
        this.redisExecProvider = redisExecProvider;
        return this;
    }

    public RedisClientBuilder ports(Collection<Integer> ports) {
        this.ports.addAll(ports);
        return this;
    }

    public RedisClientBuilder clusterReplicas(Integer clusterReplicas) {
        this.clusterReplicas = clusterReplicas;
        return this;
    }

    public RedisClient build() {
        this.tryResolveConfAndExec();
        List<String> args = this.buildCommandArgs();
        return new RedisClient(args);
    }

    public void reset() {
        this.ports.clear();
        this.executable = null;
        this.clusterReplicas = 0;
    }

    private void tryResolveConfAndExec() {
        try {
            this.resolveConfAndExec();
        }
        catch (IOException e) {
            String msg = "Could not build client instance";
            log.warn("{}. exception: {}", new Object[]{msg, e.getMessage(), e});
            throw new RedisBuildingException(msg, e);
        }
    }

    private void resolveConfAndExec() throws IOException {
        try {
            this.executable = this.redisExecProvider.get();
        }
        catch (Exception e) {
            String msg = "Failed to resolve executable";
            log.warn("{}. exception: {}", new Object[]{msg, e.getMessage(), e});
            throw new RedisBuildingException(msg, e);
        }
    }

    private List<String> buildCommandArgs() {
        LinkedList<String> args = new LinkedList<String>();
        args.add(this.executable.getAbsolutePath());
        args.add("--cluster");
        args.add("create");
        this.ports.forEach(port -> {
            String address = "127.0.0.1:" + port;
            args.add(address);
        });
        if (this.clusterReplicas > 0) {
            args.add("--cluster-replicas");
            args.add(Integer.toString(this.clusterReplicas));
        }
        args.add("--cluster-yes");
        return args;
    }

    @Generated
    public RedisClientBuilder() {
    }
}

