/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.collect.Lists;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import redis.embedded.AbstractRedisInstance;
import redis.embedded.AbstractRedisServerInstance;
import redis.embedded.IRedisServer;
import redis.embedded.RedisClient;
import redis.embedded.RedisClusterBuilder;
import redis.embedded.RedisServer;
import redis.embedded.exceptions.EmbeddedRedisException;

public class RedisCluster
implements IRedisServer {
    private final List<RedisServer> redisServers = new LinkedList<RedisServer>();
    private final RedisClient redisClient;

    RedisCluster(List<RedisServer> redisServers, RedisClient redisClient) {
        this.redisServers.addAll(redisServers);
        this.redisClient = redisClient;
    }

    public static RedisClusterBuilder builder() {
        return new RedisClusterBuilder();
    }

    @Override
    public Boolean isActive() {
        return this.redisServers.stream().allMatch(AbstractRedisInstance::isActive);
    }

    @Override
    public void start() throws EmbeddedRedisException {
        ((Stream)this.redisServers.stream().parallel()).forEach(AbstractRedisServerInstance::start);
        this.redisClient.run();
    }

    @Override
    public void stop() throws EmbeddedRedisException {
        ((Stream)this.redisServers.stream().parallel()).forEach(AbstractRedisServerInstance::stop);
    }

    @Override
    public Set<Integer> ports() {
        return new LinkedHashSet<Integer>(this.nodePorts());
    }

    public List<RedisServer> nodes() {
        return Lists.newLinkedList(this.redisServers);
    }

    public Set<Integer> nodePorts() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>();
        this.redisServers.forEach(redisServer -> ports.addAll(redisServer.ports()));
        return ports;
    }
}

