/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.RedisClient;
import redis.embedded.RedisClientBuilder;
import redis.embedded.RedisCluster;
import redis.embedded.RedisServer;
import redis.embedded.RedisServerBuilder;

public class RedisClusterBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisClusterBuilder.class);
    private final Set<Integer> nodePorts = new LinkedHashSet<Integer>();
    private RedisServerBuilder serverBuilder = new RedisServerBuilder();
    private RedisClientBuilder clientBuilder = new RedisClientBuilder();
    private Integer clusterReplicas = 0;

    public RedisClusterBuilder withServerBuilder(RedisServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    public RedisClusterBuilder withClientBuilder(RedisClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
        return this;
    }

    public RedisClusterBuilder nodePorts(Set<Integer> ports) {
        this.nodePorts.addAll(ports);
        return this;
    }

    public RedisClusterBuilder clusterReplicas(Integer clusterReplicas) {
        this.clusterReplicas = clusterReplicas;
        return this;
    }

    public RedisCluster build() {
        List<RedisServer> servers = this.buildServers();
        RedisClient client = this.buildClient();
        return new RedisCluster(servers, client);
    }

    private List<RedisServer> buildServers() {
        LinkedList<RedisServer> servers = new LinkedList<RedisServer>();
        this.nodePorts.forEach(nodePort -> {
            this.serverBuilder.reset();
            this.serverBuilder.port((Integer)nodePort);
            this.serverBuilder.clusterEnable(true);
            RedisServer server = this.serverBuilder.build();
            servers.add(server);
        });
        return servers;
    }

    private RedisClient buildClient() {
        this.clientBuilder.reset();
        this.clientBuilder.ports(this.nodePorts);
        this.clientBuilder.clusterReplicas(this.clusterReplicas);
        RedisClient client = this.clientBuilder.build();
        return client;
    }

    @Generated
    public RedisClusterBuilder() {
    }
}

