/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.util.Architecture;
import redis.embedded.util.JarUtil;
import redis.embedded.util.OS;
import redis.embedded.util.OSArchitecture;

abstract class RedisExecProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisExecProvider.class);
    protected final Map<OSArchitecture, String> executables = Maps.newHashMap();

    RedisExecProvider() {
    }

    protected abstract void initExecutables();

    public RedisExecProvider override(OS os, String executable) {
        Preconditions.checkNotNull((Object)executable);
        Arrays.stream(Architecture.values()).forEach(arch -> this.override(os, (Architecture)((Object)arch), executable));
        return this;
    }

    public RedisExecProvider override(OS os, Architecture arch, String executable) {
        Preconditions.checkNotNull((Object)executable);
        this.executables.put(new OSArchitecture(os, arch), executable);
        return this;
    }

    public File get() throws IOException {
        OSArchitecture osArch = OSArchitecture.detect();
        if (!this.executables.containsKey(osArch)) {
            String msg = "No Redis executable found for " + String.valueOf(osArch);
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        String executablePath = this.executables.get(osArch);
        return this.fileExists(executablePath) != false ? new File(executablePath) : JarUtil.extractExecutableFromJar(executablePath);
    }

    private Boolean fileExists(String executablePath) {
        return new File(executablePath).exists();
    }
}

