/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.collect.Lists;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import redis.embedded.AbstractRedisInstance;
import redis.embedded.AbstractRedisServerInstance;
import redis.embedded.IRedisServer;
import redis.embedded.RedisGatherBuilder;
import redis.embedded.RedisServer;
import redis.embedded.exceptions.EmbeddedRedisException;

public class RedisGather
implements IRedisServer {
    private final List<RedisServer> redisServers = new LinkedList<RedisServer>();

    RedisGather(List<RedisServer> redisServers) {
        this.redisServers.addAll(redisServers);
    }

    public static RedisGatherBuilder builder() {
        return new RedisGatherBuilder();
    }

    @Override
    public Boolean isActive() {
        return this.redisServers.stream().allMatch(AbstractRedisInstance::isActive);
    }

    @Override
    public void start() throws EmbeddedRedisException {
        ((Stream)this.redisServers.stream().parallel()).forEach(AbstractRedisServerInstance::start);
    }

    @Override
    public void stop() throws EmbeddedRedisException {
        ((Stream)this.redisServers.stream().parallel()).forEach(AbstractRedisServerInstance::stop);
    }

    @Override
    public Set<Integer> ports() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>(this.serverPorts());
        return ports;
    }

    public List<RedisServer> servers() {
        LinkedList servers = Lists.newLinkedList(this.redisServers);
        return servers;
    }

    public RedisServer masterServer() {
        LinkedList servers = Lists.newLinkedList(this.redisServers);
        RedisServer masterServer = (RedisServer)servers.peek();
        return masterServer;
    }

    public List<RedisServer> slaveServers() {
        LinkedList servers = Lists.newLinkedList(this.redisServers);
        RedisServer masterServer = (RedisServer)servers.pop();
        return servers;
    }

    public Set<Integer> serverPorts() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>();
        this.redisServers.forEach(redisServer -> ports.addAll(redisServer.ports()));
        return ports;
    }

    public Integer masterPort() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>(this.serverPorts());
        Integer masterPort = 0;
        Optional portOptional = ports.stream().findFirst();
        if (portOptional.isPresent()) {
            masterPort = (Integer)portOptional.get();
        }
        return masterPort;
    }

    public Set<Integer> slavePorts() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>(this.serverPorts());
        LinkedHashSet slavePorts = ports.stream().skip(1L).collect(Collectors.toCollection(LinkedHashSet::new));
        return slavePorts;
    }
}

