/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import redis.embedded.PortProvider;
import redis.embedded.RedisGather;
import redis.embedded.RedisServer;
import redis.embedded.RedisServerBuilder;
import redis.embedded.common.CommonConstant;
import redis.embedded.ports.EphemeralPortProvider;
import redis.embedded.ports.PredefinedPortProvider;
import redis.embedded.ports.SequencePortProvider;

public class RedisGatherBuilder {
    private final List<ReplicationGroup> groups = new LinkedList<ReplicationGroup>();
    private RedisServerBuilder serverBuilder = new RedisServerBuilder();
    private PortProvider replicationGroupPortProvider = new SequencePortProvider(CommonConstant.DEFAULT_REDIS_PORT);

    public RedisGatherBuilder withServerBuilder(RedisServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    public RedisGatherBuilder serverPorts(Set<Integer> ports) {
        this.replicationGroupPortProvider = new PredefinedPortProvider(ports);
        return this;
    }

    public RedisGatherBuilder serverPorts(Integer masterPort, Set<Integer> slavePorts) {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>();
        ports.add(masterPort);
        ports.addAll(slavePorts);
        this.replicationGroupPortProvider = new PredefinedPortProvider(ports);
        return this;
    }

    public RedisGatherBuilder ephemeralServers() {
        this.replicationGroupPortProvider = new EphemeralPortProvider();
        return this;
    }

    public RedisGatherBuilder ephemeral() {
        this.ephemeralServers();
        return this;
    }

    public RedisGatherBuilder replicationGroup(Integer slaveCount) {
        this.groups.add(new ReplicationGroup(slaveCount, this.replicationGroupPortProvider));
        return this;
    }

    public RedisGather build() {
        List<RedisServer> redisServers = this.buildServers();
        return new RedisGather(redisServers);
    }

    private List<RedisServer> buildServers() {
        LinkedList<RedisServer> redisServers = new LinkedList<RedisServer>();
        this.groups.forEach(group -> {
            redisServers.add(this.buildMaster((ReplicationGroup)group));
            redisServers.addAll(this.buildSlaves((ReplicationGroup)group));
        });
        return redisServers;
    }

    private List<RedisServer> buildSlaves(ReplicationGroup group) {
        LinkedList<RedisServer> redisServers = new LinkedList<RedisServer>();
        group.slavePorts.forEach(slavePort -> {
            this.serverBuilder.reset();
            this.serverBuilder.port((Integer)slavePort);
            this.serverBuilder.replicaOf(group.masterPort);
            RedisServer slave = this.serverBuilder.build();
            redisServers.add(slave);
        });
        return redisServers;
    }

    private RedisServer buildMaster(ReplicationGroup group) {
        this.serverBuilder.reset();
        RedisServer master = this.serverBuilder.port(group.masterPort).build();
        return master;
    }

    @Generated
    public RedisGatherBuilder() {
    }

    private static class ReplicationGroup {
        private final Integer masterPort;
        private final Set<Integer> slavePorts = new LinkedHashSet<Integer>();

        private ReplicationGroup(Integer slaveCount, PortProvider portProvider) {
            this.masterPort = portProvider.next();
            while (true) {
                Integer n = slaveCount;
                slaveCount = slaveCount - 1;
                if (n <= 0) break;
                this.slavePorts.add(portProvider.next());
            }
        }
    }
}

