/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.collect.Lists;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import redis.embedded.AbstractRedisInstance;
import redis.embedded.AbstractRedisServerInstance;
import redis.embedded.IRedisServer;
import redis.embedded.RedisMultipleBuilder;
import redis.embedded.RedisServer;
import redis.embedded.exceptions.EmbeddedRedisException;

public class RedisMultiple
implements IRedisServer {
    private final List<RedisServer> redisServers = new LinkedList<RedisServer>();

    RedisMultiple(List<RedisServer> redisServers) {
        this.redisServers.addAll(redisServers);
    }

    public static RedisMultipleBuilder builder() {
        return new RedisMultipleBuilder();
    }

    @Override
    public Boolean isActive() {
        return this.redisServers.stream().allMatch(AbstractRedisInstance::isActive);
    }

    @Override
    public void start() throws EmbeddedRedisException {
        ((Stream)this.redisServers.stream().parallel()).forEach(AbstractRedisServerInstance::start);
    }

    @Override
    public void stop() throws EmbeddedRedisException {
        ((Stream)this.redisServers.stream().parallel()).forEach(AbstractRedisServerInstance::stop);
    }

    @Override
    public Set<Integer> ports() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>(this.serverPorts());
        return ports;
    }

    public List<RedisServer> servers() {
        return Lists.newLinkedList(this.redisServers);
    }

    public Set<Integer> serverPorts() {
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>();
        this.redisServers.forEach(redisServer -> ports.addAll(redisServer.ports()));
        return ports;
    }
}

