/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import redis.embedded.RedisMultiple;
import redis.embedded.RedisServer;
import redis.embedded.RedisServerBuilder;

public class RedisMultipleBuilder {
    private final Set<Integer> masterPorts = new LinkedHashSet<Integer>();
    private RedisServerBuilder serverBuilder = new RedisServerBuilder();

    public RedisMultipleBuilder withServerBuilder(RedisServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    public RedisMultipleBuilder masterPorts(Set<Integer> ports) {
        this.masterPorts.addAll(ports);
        return this;
    }

    public RedisMultiple build() {
        List<RedisServer> redisServers = this.buildMasters();
        return new RedisMultiple(redisServers);
    }

    private List<RedisServer> buildMasters() {
        LinkedList<RedisServer> servers = new LinkedList<RedisServer>();
        this.masterPorts.forEach(masterPort -> {
            this.serverBuilder.reset();
            this.serverBuilder.port((Integer)masterPort);
            RedisServer server = this.serverBuilder.build();
            servers.add(server);
        });
        return servers;
    }

    @Generated
    public RedisMultipleBuilder() {
    }
}

