/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.base.Preconditions;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.RedisExecProvider;
import redis.embedded.RedisSentinel;
import redis.embedded.RedisSentinelExecProvider;
import redis.embedded.common.CommonConstant;
import redis.embedded.exceptions.RedisBuildingException;

public class RedisSentinelBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisSentinelBuilder.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String CONF_FILENAME = "embedded-redis-sentinel";
    private static final String MASTER_MONITOR_LINE = "sentinel monitor %s 127.0.0.1 %d %d";
    private static final String DOWN_AFTER_LINE = "sentinel down-after-milliseconds %s %d";
    private static final String FAILOVER_LINE = "sentinel failover-timeout %s %d";
    private static final String PARALLEL_SYNCS_LINE = "sentinel parallel-syncs %s %d";
    private static final String PORT_LINE = "port %d";
    private File executable;
    private RedisExecProvider redisExecProvider = RedisSentinelExecProvider.defaultProvider();
    private String bind = "0.0.0.0";
    private Integer sentinelPort = CommonConstant.DEFAULT_REDIS_STANDALONE_PORT;
    private Integer masterPort = CommonConstant.DEFAULT_REDIS_MASTER_PORT;
    private String masterName = "embedded-master-name";
    private Long downAfterMilliseconds = 60000L;
    private Long failoverTimeout = 180000L;
    private Integer parallelSyncs = 1;
    private Integer quorumSize = 1;
    private String sentinelConf;
    private StringBuilder redisConfigBuilder;

    public RedisSentinelBuilder redisExecProvider(RedisExecProvider redisExecProvider) {
        this.redisExecProvider = redisExecProvider;
        return this;
    }

    public RedisSentinelBuilder bind(String bind) {
        this.bind = bind;
        return this;
    }

    public RedisSentinelBuilder sentinelPort(Integer sentinelPort) {
        this.sentinelPort = sentinelPort;
        return this;
    }

    public RedisSentinelBuilder masterPort(Integer masterPort) {
        this.masterPort = masterPort;
        return this;
    }

    public RedisSentinelBuilder masterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public RedisSentinelBuilder quorumSize(Integer quorumSize) {
        this.quorumSize = quorumSize;
        return this;
    }

    public RedisSentinelBuilder downAfterMilliseconds(Long downAfterMilliseconds) {
        this.downAfterMilliseconds = downAfterMilliseconds;
        return this;
    }

    public RedisSentinelBuilder failoverTimeout(Long failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
        return this;
    }

    public RedisSentinelBuilder parallelSyncs(Integer parallelSyncs) {
        this.parallelSyncs = parallelSyncs;
        return this;
    }

    public RedisSentinelBuilder configFile(String redisConf) {
        if (this.redisConfigBuilder != null) {
            String msg = "Redis configuration is already partially build using setting(String) method!";
            log.warn(msg);
            throw new RedisBuildingException(msg);
        }
        this.sentinelConf = redisConf;
        return this;
    }

    public RedisSentinelBuilder setting(String configLine) {
        if (this.sentinelConf != null) {
            String msg = "Redis configuration is already set using redis conf file!";
            log.warn(msg);
            throw new RedisBuildingException(msg);
        }
        if (this.redisConfigBuilder == null) {
            this.redisConfigBuilder = new StringBuilder();
        }
        this.redisConfigBuilder.append(configLine);
        this.redisConfigBuilder.append(LINE_SEPARATOR);
        return this;
    }

    public RedisSentinel build() {
        this.tryResolveConfAndExec();
        List<String> args = this.buildCommandArgs();
        return new RedisSentinel(args, this.sentinelPort);
    }

    private void tryResolveConfAndExec() {
        try {
            if (this.sentinelConf == null) {
                this.resolveSentinelConf();
            }
            this.executable = this.redisExecProvider.get();
        }
        catch (Exception e) {
            String msg = "Could not build sentinel instance";
            log.warn("{}. exception: {}", new Object[]{msg, e.getMessage(), e});
            throw new RedisBuildingException(msg, e);
        }
    }

    public void reset() {
        this.redisConfigBuilder = null;
        this.sentinelConf = null;
    }

    public void addDefaultReplicationGroup() {
        this.setting(String.format(MASTER_MONITOR_LINE, this.masterName, this.masterPort, this.quorumSize));
        this.setting(String.format(DOWN_AFTER_LINE, this.masterName, this.downAfterMilliseconds));
        this.setting(String.format(FAILOVER_LINE, this.masterName, this.failoverTimeout));
        this.setting(String.format(PARALLEL_SYNCS_LINE, this.masterName, this.parallelSyncs));
    }

    private void resolveSentinelConf() throws IOException {
        if (this.redisConfigBuilder == null) {
            this.addDefaultReplicationGroup();
        }
        this.setting("bind " + this.bind);
        this.setting(String.format(PORT_LINE, this.sentinelPort));
        String configString = this.redisConfigBuilder.toString();
        File redisConfigFile = File.createTempFile(this.resolveConfigName(), ".conf");
        redisConfigFile.deleteOnExit();
        Files.asCharSink((File)redisConfigFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)configString);
        this.sentinelConf = redisConfigFile.getAbsolutePath();
    }

    private String resolveConfigName() {
        return "embedded-redis-sentinel_" + this.sentinelPort;
    }

    private List<String> buildCommandArgs() {
        Preconditions.checkNotNull((Object)this.sentinelConf);
        LinkedList<String> args = new LinkedList<String>();
        args.add(this.executable.getAbsolutePath());
        args.add(this.sentinelConf);
        args.add("--port");
        args.add(Integer.toString(this.sentinelPort));
        args.add("--loglevel");
        args.add("debug");
        args.add("--daemonize");
        args.add("no");
        args.add("--protected-mode");
        args.add("no");
        return args;
    }

    @Generated
    public RedisSentinelBuilder() {
    }
}

