/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.RedisEndpoint;
import redis.embedded.RedisExecProvider;
import redis.embedded.RedisServer;
import redis.embedded.RedisServerExecProvider;
import redis.embedded.common.CommonConstant;
import redis.embedded.exceptions.RedisBuildingException;

public class RedisServerBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisServerBuilder.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String CONF_FILENAME = "embedded-redis-server";
    private File executable;
    private RedisExecProvider redisExecProvider = RedisServerExecProvider.defaultProvider();
    private String bind = "0.0.0.0";
    private Integer port = CommonConstant.DEFAULT_REDIS_STANDALONE_PORT;
    private Boolean clusterEnable = Boolean.FALSE;
    private Boolean sentinelEnable = Boolean.FALSE;
    private RedisEndpoint replicaOf;
    private String redisConf;
    private StringBuilder redisConfigBuilder;

    public RedisServerBuilder redisExecProvider(RedisExecProvider redisExecProvider) {
        this.redisExecProvider = redisExecProvider;
        return this;
    }

    public RedisServerBuilder bind(String bind) {
        this.bind = bind;
        return this;
    }

    public RedisServerBuilder port(Integer port) {
        this.port = port;
        return this;
    }

    public RedisServerBuilder clusterEnable(Boolean enable) {
        this.clusterEnable = enable;
        return this;
    }

    public RedisServerBuilder sentinelEnable(Boolean enable) {
        this.sentinelEnable = enable;
        return this;
    }

    public RedisServerBuilder replicaOf(Integer port) {
        this.replicaOf = new RedisEndpoint("127.0.0.1", port);
        return this;
    }

    public RedisServerBuilder replicaOf(RedisEndpoint replicaOf) {
        this.replicaOf = replicaOf;
        return this;
    }

    public RedisServerBuilder configFile(String redisConf) {
        if (this.redisConfigBuilder != null) {
            String msg = "Redis configuration is already partially build using setting(String) method!";
            log.warn(msg);
            throw new RedisBuildingException(msg);
        }
        this.redisConf = redisConf;
        return this;
    }

    public RedisServerBuilder setting(String configLine) {
        if (this.redisConf != null) {
            String msg = "Redis configuration is already set using redis conf file!";
            log.warn(msg);
            throw new RedisBuildingException(msg);
        }
        if (this.redisConfigBuilder == null) {
            this.redisConfigBuilder = new StringBuilder();
        }
        this.redisConfigBuilder.append(configLine);
        this.redisConfigBuilder.append(LINE_SEPARATOR);
        return this;
    }

    public RedisServer build() {
        this.setting("bind " + this.bind);
        this.tryResolveConfAndExec();
        List<String> args = this.buildCommandArgs();
        return new RedisServer(args, this.port);
    }

    public void reset() {
        this.executable = null;
        this.redisConfigBuilder = null;
        this.replicaOf = null;
        this.redisConf = null;
        this.clusterEnable = Boolean.FALSE;
        this.sentinelEnable = Boolean.FALSE;
    }

    private void tryResolveConfAndExec() {
        try {
            this.resolveConfAndExec();
        }
        catch (IOException e) {
            String msg = "Could not build server instance";
            log.warn("{}. exception: {}", new Object[]{msg, e.getMessage(), e});
            throw new RedisBuildingException(msg, e);
        }
    }

    private void resolveConfAndExec() throws IOException {
        if (this.redisConf == null && this.redisConfigBuilder != null) {
            File redisConfigFile = File.createTempFile(this.resolveConfigName(), ".conf");
            redisConfigFile.deleteOnExit();
            Files.asCharSink((File)redisConfigFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)this.redisConfigBuilder.toString());
            this.redisConf = redisConfigFile.getAbsolutePath();
        }
        try {
            this.executable = this.redisExecProvider.get();
        }
        catch (Exception e) {
            String msg = "Failed to resolve executable";
            log.warn("{}. exception: {}", new Object[]{msg, e.getMessage(), e});
            throw new RedisBuildingException(msg, e);
        }
    }

    private String resolveConfigName() {
        return "embedded-redis-server_" + this.port;
    }

    private List<String> buildCommandArgs() {
        LinkedList<String> args = new LinkedList<String>();
        args.add(this.executable.getAbsolutePath());
        if (StringUtils.isNotEmpty((CharSequence)this.redisConf)) {
            args.add(this.redisConf);
        }
        args.add("--port");
        args.add(Integer.toString(this.port));
        if (this.replicaOf != null) {
            args.add("--replicaof");
            args.add(this.replicaOf.getHost());
            args.add(Integer.toString(this.replicaOf.getPort()));
        }
        if (this.clusterEnable.booleanValue()) {
            args.add("--cluster-enabled");
            args.add("yes");
        }
        if (this.sentinelEnable.booleanValue()) {
            args.add("--sentinel");
        }
        args.add("--loglevel");
        args.add("debug");
        args.add("--daemonize");
        args.add("no");
        args.add("--protected-mode");
        args.add("no");
        return args;
    }

    @Generated
    public RedisServerBuilder() {
    }
}

