/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import lombok.Generated;

public enum RedisInstanceModeEnum {
    INVALID(0, "invalid"),
    CLIENT(1, "client"),
    SERVER(2, "server"),
    SENTINEL(3, "sentinel");

    private static final ImmutableMap<String, RedisInstanceModeEnum> valueMapping;
    private static final ImmutableMap<Integer, RedisInstanceModeEnum> codeMapping;
    private final Integer code;
    private final String value;

    public static RedisInstanceModeEnum find(Integer code) {
        return (RedisInstanceModeEnum)((Object)codeMapping.getOrDefault((Object)code, (Object)INVALID));
    }

    public static RedisInstanceModeEnum find(String value) {
        return (RedisInstanceModeEnum)((Object)valueMapping.getOrDefault((Object)value, (Object)INVALID));
    }

    @Generated
    public Integer getCode() {
        return this.code;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    private RedisInstanceModeEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    static {
        HashMap valueMap = new HashMap();
        HashMap codeMap = new HashMap();
        RedisInstanceModeEnum[] values = RedisInstanceModeEnum.values();
        Arrays.stream(values).forEach(value -> {
            valueMap.put(value.getValue(), value);
            codeMap.put(value.getCode(), value);
        });
        valueMapping = ImmutableMap.copyOf(valueMap);
        codeMapping = ImmutableMap.copyOf(codeMap);
    }
}

