/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.util;

import java.util.LinkedHashSet;
import java.util.Set;
import redis.embedded.RedisBunch;
import redis.embedded.RedisCluster;
import redis.embedded.RedisGather;
import redis.embedded.RedisMultiple;
import redis.embedded.RedisSentinel;
import redis.embedded.RedisServer;

public class JedisUtil {
    public static Set<String> serverJedisHosts(RedisServer server) {
        Set ports = server.ports();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> bunchJedisHosts(RedisBunch bunch) {
        Set<Integer> ports = bunch.ports();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> sentinelJedisHosts(RedisBunch bunch) {
        Set<Integer> ports = bunch.sentinelPorts();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> serverJedisHosts(RedisBunch bunch) {
        Set<Integer> ports = bunch.serverPorts();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> sentinelJedisHosts(RedisSentinel sentinel) {
        Set ports = sentinel.sentinelPorts();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> masterJedisHosts(RedisSentinel sentinel) {
        Set ports = sentinel.masterPorts();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> clusterJedisHosts(RedisCluster cluster) {
        Set<Integer> ports = cluster.ports();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> multipleJedisHosts(RedisMultiple multiple) {
        Set<Integer> ports = multiple.ports();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> gatherJedisHosts(RedisGather gather) {
        Set<Integer> ports = gather.ports();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> masterJedisHosts(RedisGather gather) {
        Integer port = gather.masterPort();
        return JedisUtil.portsToJedisHost(port);
    }

    public static Set<String> slaveJedisHosts(RedisGather gather) {
        Set<Integer> ports = gather.slavePorts();
        return JedisUtil.portsToJedisHosts(ports);
    }

    public static Set<String> portsToJedisHosts(Set<Integer> ports) {
        LinkedHashSet<String> hosts = new LinkedHashSet<String>();
        ports.forEach(port -> hosts.add("127.0.0.1:" + port));
        return hosts;
    }

    public static Set<String> portsToJedisHost(Integer port) {
        LinkedHashSet<String> hosts = new LinkedHashSet<String>();
        hosts.add("127.0.0.1:" + port);
        return hosts;
    }
}

