/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.util;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.util.Architecture;
import redis.embedded.util.OS;
import redis.embedded.util.OSDetector;

public class OSArchitecture {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OSArchitecture.class);
    public static final OSArchitecture UNIX_AMD64 = new OSArchitecture(OS.UNIX, Architecture.AMD64);
    public static final OSArchitecture UNIX_ARM64 = new OSArchitecture(OS.UNIX, Architecture.ARM64);
    public static final OSArchitecture MAC_OSX_AMD64 = new OSArchitecture(OS.MAC_OSX, Architecture.AMD64);
    public static final OSArchitecture MAC_OSX_ARM64 = new OSArchitecture(OS.MAC_OSX, Architecture.ARM64);
    private final OS os;
    private final Architecture arch;

    public OSArchitecture(OS os, Architecture arch) {
        Preconditions.checkNotNull((Object)((Object)os));
        Preconditions.checkNotNull((Object)((Object)arch));
        this.os = os;
        this.arch = arch;
    }

    public static OSArchitecture detect() {
        OS os = OSDetector.getOS();
        Architecture arch = OSDetector.getArchitecture();
        log.debug("os: {} arch: {}", (Object)os, (Object)arch);
        return new OSArchitecture(os, arch);
    }

    public OS os() {
        return this.os;
    }

    public Architecture arch() {
        return this.arch;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OSArchitecture)) {
            return false;
        }
        OSArchitecture other = (OSArchitecture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OS this$os = this.os;
        OS other$os = other.os;
        if (this$os == null ? other$os != null : !((Object)((Object)this$os)).equals((Object)other$os)) {
            return false;
        }
        Architecture this$arch = this.arch;
        Architecture other$arch = other.arch;
        return !(this$arch == null ? other$arch != null : !((Object)((Object)this$arch)).equals((Object)other$arch));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OSArchitecture;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OS $os = this.os;
        result = result * 59 + ($os == null ? 43 : ((Object)((Object)$os)).hashCode());
        Architecture $arch = this.arch;
        result = result * 59 + ($arch == null ? 43 : ((Object)((Object)$arch)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OSArchitecture(os=" + String.valueOf((Object)this.os) + ", arch=" + String.valueOf((Object)this.arch) + ")";
    }
}

