/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.exceptions.OsDetectionException;
import redis.embedded.util.Architecture;
import redis.embedded.util.OS;

public class OSDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OSDetector.class);

    public static OS getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return OS.UNIX;
        }
        if ("Mac OS X".equalsIgnoreCase(osName)) {
            return OS.MAC_OSX;
        }
        String msg = "Unrecognized OS: " + osName;
        log.warn(msg);
        throw new OsDetectionException(msg);
    }

    public static Architecture getArchitecture() {
        OS os = OSDetector.getOS();
        switch (os) {
            case UNIX: 
            case MAC_OSX: {
                return OSDetector.detectionArchitecture();
            }
        }
        String msg = "Unrecognized OS: " + String.valueOf((Object)os);
        log.warn(msg);
        throw new OsDetectionException(msg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Architecture detectionArchitecture() {
        try {
            Process proc = Runtime.getRuntime().exec("uname -m");
            try (BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String machine = input.readLine();
                log.debug("machine: " + machine);
                switch (machine) {
                    case "aarch64": 
                    case "arm64": {
                        Architecture architecture = Architecture.ARM64;
                        return architecture;
                    }
                    case "x86_64": {
                        Architecture architecture = Architecture.AMD64;
                        return architecture;
                    }
                }
                String msg = "unsupported architecture: " + machine;
                log.warn(msg);
                throw new OsDetectionException(msg);
            }
        }
        catch (Exception e) {
            String msg = "get unix architecture fail";
            log.warn("{}. exception: {}", new Object[]{msg, e.getMessage(), e});
            if (!(e instanceof OsDetectionException)) throw new OsDetectionException(msg, e);
            throw (OsDetectionException)e;
        }
    }
}

