/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.glfw;

import com.lapissea.util.PairM;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWMonitorCallback;
import org.lwjgl.glfw.GLFWMonitorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;

public class GlfwMonitor {
    private static boolean INITED;
    private static GlfwMonitor PRIMARY_MONITOR;
    private static final List<GlfwMonitor> MONITORS;
    private static final List<GlfwMonitor> MONITORS_F;
    private static final List<Rect> MONITOR_GROUPS;
    private static final List<Rect> MONITOR_GROUPS_F;
    final long handle;
    public final int refreshRate;
    public final Rect bounds;

    public static void init() {
        if (INITED) {
            return;
        }
        INITED = true;
        GLFW.glfwInit();
        GlfwMonitor.update();
        GLFW.glfwSetMonitorCallback((GLFWMonitorCallbackI)GLFWMonitorCallback.create((monitor, event) -> GlfwMonitor.update()));
    }

    private static void check() {
        if (!INITED) {
            throw new IllegalStateException("\"init\" FUNCTION WAS NOT CALLED");
        }
    }

    private static void update() {
        MONITORS.clear();
        MONITOR_GROUPS.clear();
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        for (int i = 0; i < monitors.capacity(); ++i) {
            MONITORS.add(new GlfwMonitor(monitors.get(i)));
        }
        ArrayList<Rectangle2D.Float> groups = new ArrayList<Rectangle2D.Float>(1);
        ArrayList<Rectangle2D.Float> all = new ArrayList<Rectangle2D.Float>(1);
        all.addAll(MONITORS.stream().map(a -> a.bounds).collect(Collectors.toList()));
        for (GlfwMonitor m2 : MONITORS) {
            Rectangle2D group = new Rectangle2D.Float(m2.bounds.x, m2.bounds.y, m2.bounds.width, m2.bounds.height);
            boolean change = true;
            while (change) {
                change = false;
                for (Rectangle2D rectangle2D : all) {
                    boolean bottomCon;
                    boolean xFlush;
                    boolean yFlush;
                    if (rectangle2D.equals(group)) continue;
                    boolean bl = yFlush = group.getMaxY() == rectangle2D.getMaxY() && group.getMinY() == rectangle2D.getMinY();
                    if (yFlush) {
                        boolean leftCon;
                        boolean rightCon = group.getMaxX() == rectangle2D.getMinX();
                        boolean bl2 = leftCon = rectangle2D.getMaxX() == group.getMinX();
                        if (rightCon || leftCon) {
                            change = true;
                            group = group.createUnion(rectangle2D);
                        }
                    }
                    if (!(xFlush = group.getMaxX() == rectangle2D.getMaxX() && group.getMinX() == rectangle2D.getMinX())) continue;
                    boolean topCon = group.getMaxY() == rectangle2D.getMinY();
                    boolean bl3 = bottomCon = rectangle2D.getMaxY() == group.getMinY();
                    if (!topCon && !bottomCon) continue;
                    change = true;
                    group = group.createUnion(rectangle2D);
                }
            }
            if (!groups.contains(group)) {
                groups.add((Rectangle2D.Float)group);
            }
            if (all.contains(group)) continue;
            all.add((Rectangle2D.Float)group);
        }
        groups.stream().map(g -> new Rect((int)g.getX(), (int)g.getY(), (int)g.getWidth(), (int)g.getHeight())).forEach(MONITOR_GROUPS::add);
        long ph = GLFW.glfwGetPrimaryMonitor();
        PRIMARY_MONITOR = MONITORS.stream().filter(m -> m.handle == ph).findAny().orElseThrow(() -> new RuntimeException("No primary monitor in monitor list?? (bug)"));
    }

    public static GlfwMonitor getPrimaryMonitor() {
        GlfwMonitor.check();
        return PRIMARY_MONITOR;
    }

    public static List<GlfwMonitor> getMonitors() {
        GlfwMonitor.check();
        return MONITORS_F;
    }

    public static List<Rect> getGroups() {
        GlfwMonitor.check();
        return MONITOR_GROUPS_F;
    }

    public static boolean moveToVisible(Rectangle2D windowRect) {
        Optional<PairM> r;
        if (GlfwMonitor.getGroups().stream().noneMatch(group -> group.contains(windowRect)) && (r = GlfwMonitor.getGroups().stream().map(group -> new PairM(group, (Object)new Rectangle2D.Double(group.getX(), group.getY(), windowRect.getWidth(), windowRect.getHeight()).createIntersection((Rectangle2D)group))).max(Comparator.comparingDouble(a -> ((Rectangle2D)a.obj2).getWidth() * ((Rectangle2D)a.obj2).getHeight()))).isPresent()) {
            Rectangle2D intersect = (Rectangle2D)r.get().obj2;
            Rect group2 = (Rect)r.get().obj1;
            double w = Math.min(windowRect.getWidth(), group2.getWidth());
            double h = Math.min(windowRect.getHeight(), group2.getHeight());
            double x = windowRect.getMinX() < group2.getMinX() ? group2.getMinX() : (windowRect.getMaxX() > group2.getMaxX() ? group2.getMaxX() - w : windowRect.getX());
            double y = windowRect.getMinY() < group2.getMinY() ? group2.getMinY() : (windowRect.getMaxY() > group2.getMaxY() ? group2.getMaxY() - h : windowRect.getY());
            windowRect.setRect(x, y, w, h);
            return true;
        }
        return false;
    }

    public GlfwMonitor(long handle) {
        this.handle = handle;
        GLFWVidMode mode = GLFW.glfwGetVideoMode((long)handle);
        this.refreshRate = mode.refreshRate();
        int[] xBuf = new int[]{0};
        int[] yBuf = new int[]{0};
        GLFW.glfwGetMonitorPos((long)handle, (int[])xBuf, (int[])yBuf);
        this.bounds = new Rect(xBuf[0], yBuf[0], mode.width(), mode.height());
    }

    public int hashCode() {
        return this.bounds.hashCode() + this.refreshRate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GlfwMonitor)) {
            return false;
        }
        GlfwMonitor other = (GlfwMonitor)obj;
        return other.handle == this.handle;
    }

    public String toString() {
        return "GlfwMonitor{refreshRate=" + this.refreshRate + ", bounds=" + this.bounds + "}";
    }

    static {
        PRIMARY_MONITOR = null;
        MONITORS = new ArrayList<GlfwMonitor>(1);
        MONITORS_F = Collections.unmodifiableList(MONITORS);
        MONITOR_GROUPS = new ArrayList<Rect>(1);
        MONITOR_GROUPS_F = Collections.unmodifiableList(MONITOR_GROUPS);
    }

    public static final class Rect
    extends Rectangle2D {
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        public Rect(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return (float)this.width <= 0.0f || (float)this.height <= 0.0f;
        }

        @Override
        public void setRect(double x, double y, double w, double h) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int outcode(double x, double y) {
            int out = 0;
            if (this.width <= 0) {
                out |= 5;
            } else if (x < (double)this.x) {
                out |= 1;
            } else if (x > (double)this.x + (double)this.width) {
                out |= 4;
            }
            if (this.height <= 0) {
                out |= 0xA;
            } else if (y < (double)this.y) {
                out |= 2;
            } else if (y > (double)this.y + (double)this.height) {
                out |= 8;
            }
            return out;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        @Override
        public Rectangle2D createIntersection(Rectangle2D r) {
            Rectangle2D dest = r instanceof Rectangle2D.Float ? new Rectangle2D.Float() : new Rectangle2D.Double();
            Rectangle2D.intersect(this, r, dest);
            return dest;
        }

        @Override
        public Rectangle2D createUnion(Rectangle2D r) {
            Rectangle2D dest = r instanceof Rectangle2D.Float ? new Rectangle2D.Float() : new Rectangle2D.Double();
            Rectangle2D.union(this, r, dest);
            return dest;
        }

        public String toString() {
            return "Rect[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }
}

