/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.glfw;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import com.lapissea.glfw.BuffUtil;
import com.lapissea.glfw.GlfwKeyboardEvent;
import com.lapissea.glfw.GlfwMonitor;
import com.lapissea.glfw.GlfwMouseEvent;
import com.lapissea.glfw.GlfwMouseMoveEvent;
import com.lapissea.util.NotNull;
import com.lapissea.util.TextUtil;
import com.lapissea.util.UtilL;
import com.lapissea.util.event.EventRegistry;
import com.lapissea.util.event.change.ChangeRegistry;
import com.lapissea.util.event.change.ChangeRegistryBool;
import com.lapissea.util.function.BooleanConsumer;
import com.lapissea.vec.ChangeRegistryVec2i;
import com.lapissea.vec.Vec2f;
import com.lapissea.vec.Vec2i;
import com.lapissea.vec.interf.IVec2iR;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;

public class GlfwWindow {
    protected long handle = 0L;
    public final ChangeRegistry<String> title = new ChangeRegistry((Object)"", new Consumer[]{tit -> {
        if (this.isCreated()) {
            GLFW.glfwSetWindowTitle((long)this.handle, (CharSequence)tit);
        }
    }});
    public final ChangeRegistryBool maximized = new ChangeRegistryBool(false, new BooleanConsumer[]{max -> {
        if (!this.isCreated() && !this.isFullScreen()) {
            return;
        }
        if (max) {
            GLFW.glfwMaximizeWindow((long)this.handle);
        } else {
            GLFW.glfwRestoreWindow((long)this.handle);
        }
    }});
    public final ChangeRegistryBool visible = new ChangeRegistryBool(false, new BooleanConsumer[]{vis -> {
        if (!this.isCreated() && !this.isFullScreen()) {
            return;
        }
        if (vis) {
            this.moveToVisible();
            GLFW.glfwShowWindow((long)this.handle);
        } else {
            GLFW.glfwHideWindow((long)this.handle);
        }
        if (this.maximized.get()) {
            GLFW.glfwMaximizeWindow((long)this.handle);
        }
    }});
    public final ChangeRegistryVec2i size = new ChangeRegistryVec2i(600, 400, new Consumer[]{siz -> {
        if (this.isCreated() && !this.isFullScreen()) {
            GLFW.glfwSetWindowSize((long)this.handle, (int)siz.x(), (int)siz.y());
        }
    }});
    private final Vec2i restorePos = new Vec2i();
    private final Vec2i restoreSize = new Vec2i();
    public final ChangeRegistryVec2i pos = new ChangeRegistryVec2i(-1, -1, new Consumer[]{p -> {
        if (this.isCreated() && !this.isFullScreen()) {
            GLFW.glfwSetWindowPos((long)this.handle, (int)p.x(), (int)p.y());
        }
    }}){

        public ChangeRegistryVec2i set(int x, int y) {
            if (x == -1 && y == -1) {
                GlfwMonitor monitor = GlfwMonitor.getPrimaryMonitor();
                super.set((int)monitor.bounds.getCenterX() - GlfwWindow.this.size.x() / 2, (int)monitor.bounds.getCenterY() - GlfwWindow.this.size.y() / 2);
                return this;
            }
            super.set(x, y);
            return this;
        }
    };
    private boolean iconifiedEventFlag;
    public final ChangeRegistryBool iconified = new ChangeRegistryBool(false, new BooleanConsumer[]{vis -> {
        if (this.iconifiedEventFlag) {
            this.iconifiedEventFlag = false;
            return;
        }
        if (!this.isCreated() && !this.isFullScreen()) {
            return;
        }
        if (vis) {
            GLFW.glfwIconifyWindow((long)this.handle);
        } else {
            GLFW.glfwRestoreWindow((long)this.handle);
        }
        if (this.maximized.get()) {
            GLFW.glfwMaximizeWindow((long)this.handle);
        }
    }});
    public final ChangeRegistry<GlfwMonitor> monitor = new ChangeRegistry(new Consumer[]{monitor -> {
        if (!this.isCreated()) {
            return;
        }
        if (monitor == null) {
            GLFW.glfwSetWindowMonitor((long)this.handle, (long)0L, (int)this.restorePos.x(), (int)this.restorePos.y(), (int)this.restoreSize.x(), (int)this.restoreSize.y(), (int)0);
        } else {
            this.restorePos.set((Vec2i)this.pos);
            this.restoreSize.set((Vec2i)this.size);
            GLFW.glfwSetWindowMonitor((long)this.handle, (long)monitor.handle, (int)this.pos.x(), (int)this.pos.y(), (int)monitor.bounds.width, (int)monitor.bounds.height, (int)monitor.refreshRate);
        }
    }});
    private final Vec2i mousePosControl = new Vec2i();
    public final ChangeRegistryVec2i mousePos = new ChangeRegistryVec2i(new Consumer[]{pos -> {
        if (this.mousePosControl.equals(pos)) {
            return;
        }
        this.mousePosControl.set((Vec2i)pos);
        GLFW.glfwSetCursorPos((long)this.handle, (double)pos.x(), (double)pos.y());
    }});
    public final ChangeRegistryBool focused = new ChangeRegistryBool(false);
    public final KeyboardEventRegistry registryKeyboardKey = new KeyboardEventRegistry();
    public final EventRegistry<GlfwMouseEvent> registryMouseButton = new EventRegistry();
    public final EventRegistry<GlfwMouseMoveEvent> registryMouseMove = new EventRegistry();
    public final EventRegistry<Vec2f> registryMouseScroll = new EventRegistry();
    public final ChangeRegistry<Cursor> cursorMode = new ChangeRegistry((Object)Cursor.NORMAL, new Consumer[]{state -> {
        if (!this.isCreated()) {
            return;
        }
        GLFW.glfwSetInputMode((long)this.handle, (int)208897, (int)state.handle);
    }});
    private final ArrayList<Runnable> onDestroy = new ArrayList(1);

    public GlfwWindow init() {
        return this.init(SurfaceAPI.OPENGL);
    }

    public GlfwWindow init(boolean resizeable, boolean decorated) {
        return this.init(SurfaceAPI.OPENGL, resizeable, decorated, false);
    }

    public GlfwWindow init(boolean resizeable) {
        return this.init(SurfaceAPI.OPENGL, resizeable);
    }

    public GlfwWindow init(@NotNull SurfaceAPI api) {
        return this.init(api, true);
    }

    public GlfwWindow init(@NotNull SurfaceAPI api, boolean resizeable) {
        return this.init(api, resizeable, true, false);
    }

    public GlfwWindow init(@NotNull SurfaceAPI api, boolean resizeable, boolean decorated, boolean transparent) {
        this.pos.set((Vec2i)this.pos);
        this.moveToVisible();
        this.preInit(api, resizeable, decorated, transparent);
        if (this.isFullScreen()) {
            GlfwMonitor monitor = (GlfwMonitor)this.monitor.get();
            this.handle = GLFW.glfwCreateWindow((int)monitor.bounds.width, (int)monitor.bounds.height, (CharSequence)"", (long)monitor.handle, (long)this.handle);
        } else {
            this.handle = GLFW.glfwCreateWindow((int)100, (int)100, (CharSequence)"", (long)0L, (long)this.handle);
        }
        if (api == SurfaceAPI.VULKAN) {
            GLFW.glfwSetWindowSizeLimits((long)this.handle, (int)1, (int)1, (int)-1, (int)-1);
        }
        this.initProps();
        return this;
    }

    private void moveToVisible() {
        Rectangle2D.Float windowRect = new Rectangle2D.Float();
        ((Rectangle2D)windowRect).setRect(this.pos.x(), this.pos.y(), this.size.x(), this.size.y());
        if (GlfwMonitor.moveToVisible(windowRect)) {
            this.pos.set((int)((RectangularShape)windowRect).getX(), (int)((RectangularShape)windowRect).getY());
            this.size.set((int)((RectangularShape)windowRect).getWidth(), (int)((RectangularShape)windowRect).getHeight());
        }
    }

    public boolean isFullScreen() {
        return this.monitor.get() != null;
    }

    private void preInit(SurfaceAPI api, boolean resizeable, boolean decorated, boolean transparent) {
        GLFW.glfwWindowHint((int)139265, (int)api.handle);
        GLFW.glfwWindowHint((int)131075, (int)(resizeable ? 1 : 0));
        GLFW.glfwWindowHint((int)131077, (int)(decorated ? 1 : 0));
        if (this.isFullScreen()) {
            GLFW.glfwWindowHint((int)131076, (int)1);
        }
        GLFW.glfwWindowHint((int)131076, (int)(this.visible.get() ? 1 : 0));
        GLFW.glfwWindowHint((int)131082, (int)(transparent ? 1 : 0));
    }

    protected void initProps() {
        GLFW.glfwSetWindowMaximizeCallback((long)this.handle, (window, maximized) -> {
            if (window != this.handle) {
                return;
            }
            this.maximized.set(maximized);
        });
        GLFW.glfwSetWindowSizeCallback((long)this.handle, (window, w, h) -> {
            if (window != this.handle) {
                return;
            }
            this.size.set(w, h);
        });
        GLFW.glfwSetWindowPosCallback((long)this.handle, (window, xpos, ypos) -> {
            if (window != this.handle) {
                return;
            }
            this.pos.set(xpos, ypos);
        });
        GLFW.glfwSetWindowFocusCallback((long)this.handle, (window, focused) -> {
            if (window != this.handle) {
                return;
            }
            this.focused.set(focused);
        });
        GLFW.glfwSetWindowIconifyCallback((long)this.handle, (window, iconified) -> {
            if (window != this.handle) {
                return;
            }
            this.iconifiedEventFlag = true;
            this.iconified.set(iconified);
        });
        GLFW.glfwSetKeyCallback((long)this.handle, (GLFWKeyCallbackI)GLFWKeyCallback.create((window, key, scancode, action, mods) -> {
            if (window != this.handle) {
                return;
            }
            GlfwKeyboardEvent.Type type = action == 1 ? GlfwKeyboardEvent.Type.DOWN : (action == 2 ? GlfwKeyboardEvent.Type.HOLD : GlfwKeyboardEvent.Type.UP);
            GlfwKeyboardEvent e = GlfwKeyboardEvent.get(this, key, type);
            try {
                this.registryKeyboardKey.dispatch(e);
            }
            finally {
                GlfwKeyboardEvent.give(e);
            }
        }));
        GLFW.glfwSetMouseButtonCallback((long)this.handle, (GLFWMouseButtonCallbackI)GLFWMouseButtonCallback.create((window, button, action, mods) -> {
            if (window != this.handle) {
                return;
            }
            GlfwMouseEvent.Type type = action == 1 ? GlfwMouseEvent.Type.DOWN : (action == 2 ? GlfwMouseEvent.Type.HOLD : GlfwMouseEvent.Type.UP);
            GlfwMouseEvent e = GlfwMouseEvent.get(this, button, type);
            try {
                this.registryMouseButton.dispatch((Object)e);
            }
            finally {
                GlfwMouseEvent.give(e);
            }
        }));
        GLFW.glfwSetCursorPosCallback((long)this.handle, (GLFWCursorPosCallbackI)GLFWCursorPosCallback.create((window, xpos, ypos) -> {
            if (window != this.handle) {
                return;
            }
            this.mousePosControl.set((int)xpos, (int)ypos);
            Vec2i delta = this.mousePosControl.clone().sub((Vec2i)this.mousePos);
            this.mousePos.set(this.mousePosControl);
            GlfwMouseMoveEvent e = GlfwMouseMoveEvent.get(this, (IVec2iR)delta, (IVec2iR)this.mousePos);
            try {
                this.registryMouseMove.dispatch((Object)e);
            }
            finally {
                GlfwMouseMoveEvent.give(e);
            }
        }));
        GLFW.glfwSetScrollCallback((long)this.handle, (window, xoffset, yoffset) -> {
            if (window != this.handle) {
                return;
            }
            this.registryMouseScroll.dispatch((Object)new Vec2f((float)xoffset, (float)yoffset));
        });
        this.title.dispatch((Object)((String)this.title.get()));
        if (!this.isFullScreen()) {
            this.pos.dispatch(this.pos);
            this.size.dispatch(this.size);
            if (this.visible.get()) {
                this.maximized.dispatch(this.maximized.get());
            }
        }
        this.cursorMode.dispatch((Object)((Cursor)((Object)this.cursorMode.get())));
        this.focus();
        this.focused.set(true);
    }

    public boolean isKeyDown(int key) {
        this.requireCreated();
        return GLFW.glfwGetKey((long)this.handle, (int)key) == 1;
    }

    public boolean isMouseKeyDown(int key) {
        this.requireCreated();
        return GLFW.glfwGetMouseButton((long)this.handle, (int)key) == 1;
    }

    public GlfwWindow setUserPointer(@NotNull PointerBuffer pointer) {
        return this.setUserPointer(pointer.address());
    }

    public GlfwWindow setUserPointer(long pointer) {
        this.requireCreated();
        GLFW.glfwSetWindowUserPointer((long)this.handle, (long)pointer);
        return this;
    }

    public long getUserPointer() {
        return GLFW.glfwGetWindowUserPointer((long)this.handle);
    }

    public void setIcon(BufferedImage ... images) {
        if (images.length == 0) {
            return;
        }
        this.setIcon((GLFWImage[])UtilL.convert((Object[])images, GLFWImage[]::new, image -> GLFWImage.create().set(image.getWidth(), image.getHeight(), BuffUtil.imageToBuffer(image, MemoryUtil.memAlloc((int)(image.getWidth() * image.getHeight() * 4))))));
    }

    public void setIcon(GLFWImage ... images) {
        if (images.length == 0) {
            return;
        }
        try (GLFWImage.Buffer iconSet = GLFWImage.malloc((int)images.length);){
            for (int i = images.length - 1; i >= 0; --i) {
                iconSet.put(i, (Struct)images[i]);
            }
            GLFW.glfwSetWindowIcon((long)this.handle, (GLFWImage.Buffer)iconSet);
        }
    }

    public boolean isCreated() {
        return this.handle != 0L;
    }

    public void pollEvents() {
        GLFW.glfwPollEvents();
    }

    public void waitEvents() {
        GLFW.glfwWaitEvents();
    }

    public boolean shouldClose() {
        if (!this.isCreated()) {
            return true;
        }
        return GLFW.glfwWindowShouldClose((long)this.handle);
    }

    public void destroy() {
        this.requireCreated();
        this.onDestroy.forEach(Runnable::run);
        this.onDestroy.clear();
        GLFW.glfwDestroyWindow((long)this.handle);
        this.handle = 0L;
    }

    public void hide() {
        this.visible.set(false);
    }

    public void show() {
        this.visible.set(true);
    }

    public boolean isVisible() {
        return this.visible.get() && this.size.x() != 0 && this.size.y() != 0;
    }

    public void swapBuffers() {
        this.requireCreated();
        GLFW.glfwSwapBuffers((long)this.handle);
    }

    public GlfwWindow loadState(String data) {
        return this.loadState((Map)new Gson().fromJson(data, HashMap.class));
    }

    public GlfwWindow loadState(File file) {
        GlfwWindow glfwWindow;
        if (file.length() == 0L) {
            return this;
        }
        BufferedReader data = new BufferedReader(new FileReader(file));
        try {
            glfwWindow = this.loadState(data);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)data).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return this;
            }
        }
        ((Reader)data).close();
        return glfwWindow;
    }

    public GlfwWindow loadState(Reader data) {
        return this.loadState((Map)new Gson().fromJson(data, HashMap.class));
    }

    public GlfwWindow loadState(Map<String, LinkedTreeMap> data) {
        try {
            IntBuffer target = ByteBuffer.wrap(TextUtil.hexStringToByteArray((String)data.get("target").toString())).order(ByteOrder.nativeOrder()).asIntBuffer();
            Rectangle2D.Float rect = new Rectangle2D.Float(target.get(), target.get(), target.get(), target.get());
            this.monitor.set((Object)GlfwMonitor.getMonitors().stream().filter(m -> m.bounds.equals(rect)).findAny().orElseGet(GlfwMonitor::getPrimaryMonitor));
            this.size.set(((GlfwMonitor)this.monitor.get()).bounds.width, ((GlfwMonitor)this.monitor.get()).bounds.height);
            try {
                LinkedTreeMap restore = data.get("restore");
                LinkedTreeMap sizeD = (LinkedTreeMap)restore.get((Object)"size");
                LinkedTreeMap posD = (LinkedTreeMap)restore.get((Object)"location");
                this.restoreSize.set(((Number)sizeD.getOrDefault((Object)"width", (Object)this.size.x())).intValue(), ((Number)sizeD.getOrDefault((Object)"height", (Object)this.size.y())).intValue());
                this.restorePos.set(((Number)posD.getOrDefault((Object)"top", (Object)this.pos.x())).intValue(), ((Number)posD.getOrDefault((Object)"left", (Object)this.pos.y())).intValue());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this;
        }
        catch (Throwable target) {
            try {
                LinkedTreeMap size = data.get("size");
                this.size.set(((Number)size.getOrDefault((Object)"width", (Object)this.size.x())).intValue(), ((Number)size.getOrDefault((Object)"height", (Object)this.size.y())).intValue());
            }
            catch (Throwable size) {
                // empty catch block
            }
            try {
                LinkedTreeMap pos = data.get("location");
                this.pos.set(((Number)pos.getOrDefault((Object)"top", (Object)this.pos.x())).intValue(), ((Number)pos.getOrDefault((Object)"left", (Object)this.pos.y())).intValue());
            }
            catch (Throwable pos) {
                // empty catch block
            }
            try {
                this.maximized.set(Boolean.parseBoolean(data.get("max") + ""));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return this;
        }
    }

    @NotNull
    private Gson getG() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    public GlfwWindow saveState(File file) {
        File tmp = new File(file.getPath() + "@");
        try (BufferedWriter data = new BufferedWriter(new FileWriter(tmp));){
            this.saveState(data);
        }
        catch (Exception ignored) {
            return this;
        }
        file.delete();
        tmp.renameTo(file);
        return this;
    }

    public GlfwWindow saveState(Writer out) {
        this.getG().toJson((JsonElement)this.saveState(new JsonObject()), (Appendable)out);
        return this;
    }

    public String saveState() {
        return this.getG().toJson((JsonElement)this.saveState(new JsonObject()));
    }

    public JsonObject saveState(JsonObject json) {
        this.requireCreated();
        if (this.isFullScreen()) {
            ByteBuffer bytes = ByteBuffer.allocate(16).order(ByteOrder.nativeOrder());
            GlfwMonitor m = (GlfwMonitor)this.monitor.get();
            bytes.putInt(m.bounds.x);
            bytes.putInt(m.bounds.y);
            bytes.putInt(m.bounds.width);
            bytes.putInt(m.bounds.height);
            json.addProperty("target", TextUtil.bytesToHex((byte[])bytes.array()));
            JsonObject restore = new JsonObject();
            JsonObject size = new JsonObject();
            size.addProperty("width", (Number)this.restoreSize.x());
            size.addProperty("height", (Number)this.restoreSize.y());
            JsonObject location = new JsonObject();
            location.addProperty("top", (Number)this.restorePos.x());
            location.addProperty("left", (Number)this.restorePos.y());
            restore.add("size", (JsonElement)size);
            restore.add("location", (JsonElement)location);
            json.add("restore", (JsonElement)restore);
        } else {
            ChangeRegistryVec2i resPos;
            ChangeRegistryVec2i resSiz;
            boolean max;
            boolean ico;
            boolean visible = this.isVisible();
            if (!visible) {
                ico = this.iconified.get();
                boolean bl = max = !ico && this.maximized.get();
                if (max) {
                    this.maximized.set(false);
                }
                if (ico) {
                    this.iconified.set(false);
                }
                resSiz = this.size;
                resPos = this.pos;
            } else {
                max = false;
                ico = false;
                if (this.restorePos.equals(0, 0)) {
                    this.restorePos.set((Vec2i)this.pos);
                }
                if (this.restoreSize.equals(0, 0)) {
                    this.restoreSize.set((Vec2i)this.size);
                }
                resSiz = this.restoreSize;
                resPos = this.restorePos;
            }
            JsonObject size = new JsonObject();
            size.addProperty("width", (Number)resSiz.x());
            size.addProperty("height", (Number)resSiz.y());
            JsonObject location = new JsonObject();
            location.addProperty("top", (Number)resPos.x());
            location.addProperty("left", (Number)resPos.y());
            if (max) {
                this.maximized.set(true);
            }
            if (ico) {
                this.iconified.set(true);
            }
            json.add("size", (JsonElement)size);
            json.add("location", (JsonElement)location);
            json.addProperty("max", Boolean.valueOf(this.maximized.get()));
        }
        return json;
    }

    public void setAutoFullScreen() {
        this.monitor.set((Object)this.getBestScreen());
    }

    private GlfwMonitor getBestScreen() {
        GlfwMonitor.init();
        this.pos.set((Vec2i)this.pos);
        Rectangle2D.Float windowRect = new Rectangle2D.Float();
        ((Rectangle2D)windowRect).setRect(this.pos.x(), this.pos.y(), this.size.x(), this.size.y());
        GlfwMonitor.moveToVisible(windowRect);
        GlfwMonitor best = null;
        double bestOverlap = 0.0;
        for (GlfwMonitor monitor : GlfwMonitor.getMonitors()) {
            Rectangle2D overlapRect = ((Rectangle2D)windowRect).createIntersection(monitor.bounds);
            double overlap = overlapRect.getWidth() * overlapRect.getHeight();
            if (!(bestOverlap < overlap)) continue;
            best = monitor;
            bestOverlap = overlap;
        }
        return best;
    }

    public void requestClose() {
        this.requireCreated();
        GLFW.glfwSetWindowShouldClose((long)this.handle, (boolean)true);
    }

    public boolean isFocused() {
        return this.focused.get();
    }

    public void focus() {
        GLFW.glfwFocusWindow((long)this.handle);
    }

    public void toggleFullScreen() {
        if (this.monitor.get() != null) {
            this.monitor.set(null);
        } else {
            this.setAutoFullScreen();
        }
    }

    public CompletableFuture<Void> whileOpen(@NotNull Runnable run, @NotNull String name) {
        return this.whileOpen(run, name, Thread::new);
    }

    public CompletableFuture<Void> whileOpen(@NotNull Runnable run, @NotNull String name, @NotNull BiFunction<Runnable, String, Thread> newThread) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        newThread.apply(() -> {
            this.whileOpen(run);
            future.complete(null);
        }, name).start();
        return future;
    }

    public void whileOpen(@NotNull Runnable run) {
        while (!this.shouldClose()) {
            run.run();
        }
    }

    public void centerMouse() {
        this.mousePos.set(this.size.x() / 2, this.size.y() / 2);
    }

    public String toString() {
        return "GlfwWindowVk{" + (String)this.title.get() + "}";
    }

    public void useThisThread() {
        this.requireCreated();
        GLFW.glfwMakeContextCurrent((long)this.handle);
    }

    private void requireCreated() {
        if (!this.isCreated()) {
            throw new IllegalStateException();
        }
    }

    public void centerWindow() {
        GlfwMonitor monitor = this.getBestScreen();
        this.pos.set((int)monitor.bounds.getCenterX() - this.size.x() / 2, (int)monitor.bounds.getCenterY() - this.size.y() / 2);
    }

    public void pollEventsWhileOpen() {
        this.whileOpen(() -> {
            UtilL.sleep((long)0L, (int)1000);
            this.pollEvents();
        });
        this.hide();
    }

    public void autoHandleStateSaving(File saveFile) {
        this.autoHandleStateSaving(saveFile, 1000);
    }

    public void autoHandleStateSaving(File saveFile, int timeoutInterval) {
        this.loadState(saveFile);
        long[] lastChangePtr = new long[]{System.currentTimeMillis()};
        long[] lastSavePtr = new long[]{lastChangePtr[0]};
        Thread[] targetThreadPtr = new Thread[]{null};
        this.whileOpen(() -> {
            targetThreadPtr[0] = Thread.currentThread();
            long lastChange = lastChangePtr[0];
            if (this.iconified.get() || lastChange == lastSavePtr[0] || System.currentTimeMillis() < lastChange + (long)timeoutInterval) {
                UtilL.sleep((long)timeoutInterval);
                return;
            }
            lastSavePtr[0] = lastChange;
            this.saveState(saveFile);
            UtilL.sleep((long)timeoutInterval);
        }, "GlfwStateMonitor");
        UtilL.sleepWhile(() -> targetThreadPtr[0] == null);
        Runnable changeEvent = () -> {
            lastChangePtr[0] = System.currentTimeMillis();
            targetThreadPtr[0].interrupt();
        };
        this.size.register(changeEvent);
        this.pos.register(changeEvent);
        this.monitor.register(m -> changeEvent.run());
        this.onDestroy(() -> this.saveState(saveFile));
    }

    public void autoF11Toggle() {
        this.registryKeyboardKey.register(300, GlfwKeyboardEvent.Type.DOWN, e -> this.toggleFullScreen());
    }

    public long getHandle() {
        return this.handle;
    }

    public void onDestroy(Runnable event) {
        this.onDestroy.add(event);
    }

    public boolean isIconified() {
        return this.iconified.get();
    }

    public void grabContext() {
        this.requireCreated();
        GLFW.glfwMakeContextCurrent((long)this.handle);
    }

    public static class KeyboardEventRegistry
    extends EventRegistry<GlfwKeyboardEvent> {
        public boolean register(int key, GlfwKeyboardEvent.Type type, @NotNull Consumer<GlfwKeyboardEvent> listener) {
            return this.register(e -> {
                if (e.key == key && e.type == type) {
                    listener.accept((GlfwKeyboardEvent)e);
                }
            });
        }
    }

    public static enum Cursor {
        NORMAL(212993),
        HIDDEN(212994),
        DISABLED(212995);

        protected final int handle;

        private Cursor(int handle) {
            this.handle = handle;
        }
    }

    public static enum SurfaceAPI {
        OPENGL(196609),
        OPENGL_ES(196610),
        VULKAN(0);

        protected final int handle;

        private SurfaceAPI(int handle) {
            this.handle = handle;
        }
    }
}

