/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.encoding.tag;

public enum TagClass {
    Universal(0),
    Application(64),
    Private(192),
    ContextSpecific(128);

    private final byte code;

    private TagClass(int code) {
        this.code = (byte)code;
    }

    public static TagClass find(String value) {
        for (TagClass aClass : TagClass.values()) {
            if (!aClass.name().equalsIgnoreCase(value)) continue;
            return aClass;
        }
        throw new IllegalArgumentException("Invalid tag class: " + value);
    }

    public static TagClass findByCode(byte code) {
        for (TagClass aClass : TagClass.values()) {
            if (code != aClass.getCode()) continue;
            return aClass;
        }
        throw new IllegalArgumentException("Unknown code: " + code);
    }

    public int getCode() {
        return this.code;
    }
}

