/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.module;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleReference
implements Comparable<ModuleReference> {
    private final String name;
    private final long[] oid;
    private final String oidString;
    private final String iri;

    public ModuleReference(String name) {
        this(name, null, null);
    }

    public ModuleReference(@NotNull String name, @Nullable long[] oid, @Nullable String iri) {
        this.name = name;
        this.oid = oid != null ? Arrays.copyOf(oid, oid.length) : null;
        this.oidString = oid != null ? StringUtils.join((Object[])new Serializable[]{oid, "-"}) : null;
        this.iri = iri;
    }

    public String getName() {
        return this.name;
    }

    public long[] getOid() {
        return Arrays.copyOf(this.oid, this.oid.length);
    }

    public String getOidString() {
        return this.oidString;
    }

    public String getIri() {
        return this.iri;
    }

    @Override
    public int compareTo(@NotNull ModuleReference o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleReference)) {
            return false;
        }
        ModuleReference reference = (ModuleReference)obj;
        return this.getName().equals(reference.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        if (this.oid == null && this.iri == null) {
            return this.getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        if (this.oid != null) {
            sb.append(" {").append(this.getOidString()).append('}');
        }
        if (this.iri != null) {
            sb.append(' ').append(this.getIri());
        }
        return sb.toString();
    }
}

