/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.type;

import org.asn1s.api.util.RefUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeName
implements Comparable<TypeName> {
    private final String name;
    private final String moduleName;

    public TypeName(@NotNull String name, @Nullable String moduleName) {
        RefUtils.assertTypeRef(name);
        if (moduleName != null) {
            RefUtils.assertTypeRef(moduleName);
        }
        this.name = name;
        this.moduleName = moduleName;
    }

    public String getName() {
        return this.name;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public int compareTo(@NotNull TypeName o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeName)) {
            return false;
        }
        TypeName typeName = (TypeName)obj;
        if (!this.getName().equals(typeName.getName())) {
            return false;
        }
        return this.getModuleName() != null ? this.getModuleName().equals(typeName.getModuleName()) : typeName.getModuleName() == null;
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + (this.getModuleName() != null ? this.getModuleName().hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.moduleName == null) {
            return this.name;
        }
        return this.moduleName + '.' + this.name;
    }
}

