/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.util;

import java.util.HashSet;
import org.asn1s.api.Ref;
import org.asn1s.api.value.Value;
import org.asn1s.api.value.x680.NamedValue;
import org.jetbrains.annotations.NotNull;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    @NotNull
    public static String convertToBString(Iterable<? extends Ref<Value>> valueList, int desiredSize) {
        HashSet<Long> values = new HashSet<Long>();
        Long maxValue = 0L;
        for (Ref<Value> ref : valueList) {
            NamedValue value = (NamedValue)ref;
            if (value.getReferenceKind() != Value.Kind.Integer || !value.toIntegerValue().isLong()) {
                throw new IllegalStateException();
            }
            Long longValue = value.toIntegerValue().asLong();
            values.add(longValue);
            maxValue = Math.max(maxValue, longValue);
        }
        if (desiredSize > -1) {
            if (maxValue > (long)(desiredSize - 1)) {
                throw new IllegalArgumentException("Unable to truncate data. Desired size is smaller than expected: current = " + (maxValue + 1L) + " desired = " + desiredSize);
            }
            maxValue = (long)desiredSize - 1L;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        for (long i = 0L; i <= maxValue; ++i) {
            sb.append(values.contains(i) ? (char)'1' : '0');
        }
        sb.append("'B");
        return sb.toString();
    }
}

