/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.util;

import java.math.BigInteger;
import java.util.regex.Pattern;

public final class NRxUtils {
    private static final int MAX_LONG_DECIMALS = 16;
    private static final BigInteger BIG_ZERO = new BigInteger("0");
    private static final Pattern FORMAT_PATTERN = Pattern.compile("^[+\\-]?(0|[1-9]\\d*)(\\.\\d+?([eE][+\\-]?\\d+)?)?$");

    private NRxUtils() {
    }

    public static String toCanonicalNR3(String value) {
        String actualMantis;
        int scale;
        String exponentStr;
        String mantisStr;
        if ("-Infinity".equals(value) || "Infinity".equals(value) || "NaN".equals(value)) {
            return value;
        }
        if (!FORMAT_PATTERN.matcher(value).matches()) {
            throw new IllegalArgumentException();
        }
        int expIndex = (value = value.toUpperCase()).indexOf(69);
        if (expIndex == -1) {
            mantisStr = value;
            exponentStr = "0";
        } else {
            mantisStr = value.substring(0, expIndex).trim();
            exponentStr = value.substring(expIndex + 1).trim();
        }
        int dotIndex = mantisStr.indexOf(46);
        if (dotIndex == -1) {
            scale = 0;
            actualMantis = mantisStr;
        } else {
            scale = mantisStr.length() - dotIndex - 1;
            String fracture = mantisStr.substring(dotIndex + 1);
            if (NRxUtils.isAllZeros(fracture)) {
                scale -= fracture.length();
                fracture = "";
            }
            actualMantis = mantisStr.substring(0, dotIndex) + fracture;
        }
        return NRxUtils.formatInt(actualMantis) + ".E" + NRxUtils.formatExponent(scale, exponentStr);
    }

    private static boolean isAllZeros(CharSequence fracture) {
        for (int i = 0; i < fracture.length(); ++i) {
            if (fracture.charAt(i) == '0') continue;
            return false;
        }
        return true;
    }

    private static String formatExponent(int scale, String exponent) {
        if (scale == 0) {
            return NRxUtils.formatInt(exponent);
        }
        if (exponent.length() > 16) {
            BigInteger integer = new BigInteger(exponent);
            BigInteger scaleInt = new BigInteger(Integer.toString(scale));
            if (BIG_ZERO.equals(integer = integer.subtract(scaleInt))) {
                return "+0";
            }
            return integer.toString();
        }
        long value = Long.parseLong(exponent) - (long)scale;
        if (value == 0L) {
            return "+0";
        }
        return Long.toString(value);
    }

    private static String formatInt(String mantis) {
        if (mantis.length() > 16) {
            BigInteger integer = new BigInteger(mantis);
            if (BIG_ZERO.equals(integer)) {
                return "+0";
            }
            return integer.toString();
        }
        long value = Long.parseLong(mantis);
        if (value == 0L) {
            return "+0";
        }
        return Long.toString(value);
    }
}

