/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.util;

import java.util.regex.Pattern;
import org.asn1s.api.Ref;
import org.asn1s.api.Scope;
import org.asn1s.api.exception.ResolutionException;
import org.asn1s.api.type.ComponentType;
import org.asn1s.api.type.Type;
import org.asn1s.api.type.TypeNameRef;
import org.asn1s.api.value.Value;
import org.asn1s.api.value.ValueNameRef;
import org.asn1s.api.value.x680.NamedValue;
import org.jetbrains.annotations.Nullable;

public final class RefUtils {
    private static final Pattern TIME_VALUE_PATTERN = Pattern.compile("^\"[0-9+\\-:.,/CDHMRPSTWZ]+\"$");
    private static final Pattern TYPE_REF_PATTERN = Pattern.compile("^([A-Z][A-Za-z0-9]*([\\-][A-Za-z0-9]+)*|(BIT|OCTET|CHARACTER)\\s+STRING|OBJECT\\s+IDENTIFIER|EMBEDDED\\s+PDV|INSTANCE\\s+OF)$");
    private static final Pattern VALUE_REF_PATTERN = Pattern.compile("^[a-z][A-Za-z0-9]*([\\-][A-Za-z0-9]+)*$");
    private static final Pattern IRI_PATTERN = Pattern.compile("^\"(/[A-Za-z0-9]+)+\"$");

    private RefUtils() {
    }

    public static void assertTypeRef(String name) {
        if (!RefUtils.isTypeRef(name)) {
            throw new IllegalArgumentException("Not a type reference: " + name);
        }
    }

    public static boolean isSameAsDefaultValue(Scope scope, ComponentType component, Value resolve) throws ResolutionException {
        if (component.getDefaultValue() == null) {
            return false;
        }
        resolve = RefUtils.toBasicValue(scope, resolve);
        Value value = RefUtils.toBasicValue(scope, component.getDefaultValue());
        return resolve.isEqualTo(value);
    }

    public static boolean isTypeRef(CharSequence name) {
        return name != null && TYPE_REF_PATTERN.matcher(name).matches();
    }

    public static void assertValueRef(String name) {
        if (!RefUtils.isValueRef(name)) {
            throw new IllegalArgumentException("Not a value reference: " + name);
        }
    }

    public static boolean isValueRef(CharSequence name) {
        return VALUE_REF_PATTERN.matcher(name).matches();
    }

    public static boolean isIriValue(CharSequence value) {
        return IRI_PATTERN.matcher(value).matches();
    }

    public static void assertIriValue(String value) {
        if (!RefUtils.isIriValue(value)) {
            throw new IllegalArgumentException("Is not IRI value: " + value);
        }
    }

    public static Value toBasicValue(Scope scope, Ref<Value> ref) throws ResolutionException {
        Value value = ref.resolve(scope);
        if (value.getKind() == Value.Kind.Name) {
            NamedValue namedValue = value.toNamedValue();
            if (namedValue.getValueRef() == null) {
                return namedValue;
            }
            return RefUtils.toBasicValue(scope, namedValue.getValueRef());
        }
        return value;
    }

    public static boolean isValueRef(@Nullable Ref<?> ref) {
        return ref instanceof Value || ref instanceof ValueNameRef;
    }

    public static boolean isTypeRef(@Nullable Ref<?> ref) {
        return ref instanceof Type || ref instanceof TypeNameRef;
    }
}

