/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.value.x680;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.asn1s.api.value.Value;
import org.jetbrains.annotations.NotNull;

public interface IntegerValue
extends Value {
    public boolean isInt();

    public boolean isLong();

    public boolean isBigInteger();

    default public boolean isFloat() {
        return this.ordinal() < 3;
    }

    default public boolean isDouble() {
        return this.ordinal() < 3;
    }

    public boolean isZero();

    public int ordinal();

    public int asInt();

    public long asLong();

    public BigInteger asBigInteger();

    public IntegerValue negate();

    default public float asFloat() {
        if (this.isInt()) {
            return this.asInt();
        }
        if (this.isLong()) {
            return this.asLong();
        }
        throw new UnsupportedOperationException();
    }

    default public double asDouble() {
        if (this.isLong()) {
            return this.asLong();
        }
        throw new UnsupportedOperationException();
    }

    default public BigDecimal asBigDecimal() {
        if (this.isLong()) {
            return new BigDecimal(this.asLong());
        }
        return new BigDecimal(this.asBigInteger());
    }

    @Override
    @NotNull
    default public Value.Kind getKind() {
        return Value.Kind.Integer;
    }
}

