/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.value.x681;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.asn1s.api.Ref;
import org.asn1s.api.value.Value;
import org.jetbrains.annotations.NotNull;

public class ObjectValue
implements Value {
    private final Map<String, Ref<?>> fields;

    public ObjectValue(Map<String, Ref<?>> fields) {
        this.fields = new HashMap(fields);
    }

    public Map<String, Ref<?>> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    @Override
    @NotNull
    public Value.Kind getKind() {
        return Value.Kind.Object;
    }

    @Override
    public int compareTo(@NotNull Value o) {
        if (o.getKind() == Value.Kind.Object) {
            return this.compareToObjectValue(o.toObjectValue());
        }
        return this.getKind().compareTo(o.getKind());
    }

    private int compareToObjectValue(ObjectValue objectValue) {
        Map<String, Ref<?>> rhsFields = objectValue.getFields();
        int result = Integer.compare(this.fields.size(), rhsFields.size());
        if (result != 0) {
            return result;
        }
        ArrayList<String> lhs = new ArrayList<String>(this.fields.keySet());
        Collections.sort(lhs);
        ArrayList<String> rhs = new ArrayList<String>(rhsFields.keySet());
        Collections.sort(rhs);
        result = ((Object)lhs).toString().compareTo(((Object)rhs).toString());
        if (result != 0) {
            return result;
        }
        for (Map.Entry<String, Ref<?>> entry : this.fields.entrySet()) {
            Ref<?> ref = rhsFields.get(entry.getKey());
            result = ref instanceof Value && entry.getValue() instanceof Value ? ((Value)entry.getValue()).compareTo((Value)ref) : entry.getValue().toString().compareTo(ref.toString());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (Map.Entry<String, Ref<?>> entry : this.fields.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append(' ').append(entry.getValue());
        }
        sb.append(" }");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectValue)) {
            return false;
        }
        ObjectValue objectValue = (ObjectValue)obj;
        return this.getFields().equals(objectValue.getFields());
    }

    public int hashCode() {
        return this.getFields().hashCode();
    }
}

