/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.java.awt;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import org.apache.poi.java.awt.BasicStroke;
import org.apache.poi.java.awt.Color;
import org.apache.poi.java.awt.Graphics;
import org.apache.poi.java.awt.Image;
import org.apache.poi.java.awt.Paint;
import org.apache.poi.java.awt.RenderingHints;
import org.apache.poi.java.awt.Shape;
import org.apache.poi.java.awt.Stroke;
import org.apache.poi.java.awt.font.FontRenderContext;
import org.apache.poi.java.awt.font.TextLayout;
import org.apache.poi.java.awt.geom.AffineTransform;
import org.apache.poi.java.awt.geom.PathIterator;
import org.apache.poi.java.awt.image.BufferedImage;
import org.apache.poi.java.awt.image.ImageObserver;
import org.apache.poi.java.awt.image.RenderedImage;
import org.apache.poi.xslf.usermodel.XSLFRenderingHint;

public class Graphics2D
extends Graphics {
    android.graphics.Paint paint;
    public Canvas canvas;
    Stroke stroke;
    Color color = Color.white;
    Color bgColor;
    AffineTransform transform;
    private HashMap<RenderingHints.Key, Object> hintMap = new HashMap();

    public Graphics2D(Canvas canvas) {
        this.canvas = canvas;
        this.transform = new AffineTransform();
        this.paint = new android.graphics.Paint();
        this.paint.setAntiAlias(true);
    }

    public void setColor(Color color) {
        this.color = color;
        this.paint.setColor(this.color.getRGB());
    }

    public Color getColor() {
        return this.color;
    }

    public void setStroke(Stroke pStroke) {
        this.stroke = pStroke;
        BasicStroke stroke = (BasicStroke)pStroke;
        Paint.Cap cap = Paint.Cap.BUTT;
        switch (stroke.getEndCap()) {
            case 0: {
                cap = Paint.Cap.BUTT;
                break;
            }
            case 1: {
                cap = Paint.Cap.ROUND;
                break;
            }
            case 2: {
                cap = Paint.Cap.SQUARE;
            }
        }
        this.paint.setStrokeCap(cap);
        Paint.Join join = Paint.Join.BEVEL;
        switch (stroke.getLineJoin()) {
            case 2: {
                join = Paint.Join.BEVEL;
                break;
            }
            case 0: {
                join = Paint.Join.MITER;
                break;
            }
            case 1: {
                join = Paint.Join.ROUND;
            }
        }
        this.paint.setStrokeJoin(join);
        this.paint.setStrokeMiter(stroke.getMiterLimit());
        this.paint.setStrokeWidth(stroke.getLineWidth());
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void draw(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        final Path path = this.convertAwtPathToAndroid(pi);
        this.paint.setStyle(Paint.Style.STROKE);
        this.drawMatrix2Canvas(new Runnable(){

            @Override
            public void run() {
                Graphics2D.this.canvas.drawPath(path, Graphics2D.this.paint);
            }
        });
    }

    public void fill(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        final Path path = this.convertAwtPathToAndroid(pi);
        this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.drawMatrix2Canvas(new Runnable(){

            @Override
            public void run() {
                Graphics2D.this.canvas.drawPath(path, Graphics2D.this.paint);
            }
        });
    }

    private Path convertAwtPathToAndroid(PathIterator pi) {
        Path path = new Path();
        float[] coords = new float[6];
        while (!pi.isDone()) {
            int windingRule = pi.getWindingRule();
            if (windingRule == 0) {
                path.setFillType(Path.FillType.EVEN_ODD);
            } else {
                path.setFillType(Path.FillType.WINDING);
            }
            int pathType = pi.currentSegment(coords);
            switch (pathType) {
                case 4: {
                    path.close();
                    break;
                }
                case 3: {
                    path.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            pi.next();
        }
        return path;
    }

    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    private Matrix matrix() {
        AffineTransform at = this.transform;
        Matrix m = new Matrix();
        float[] values = new float[9];
        values[0] = (float)at.getScaleX();
        values[4] = (float)at.getScaleY();
        values[2] = (float)at.getTranslateX();
        values[5] = (float)at.getTranslateY();
        values[1] = (float)at.getShearX();
        values[3] = (float)at.getShearY();
        values[8] = 1.0f;
        m.setValues(values);
        return m;
    }

    public void setTransform(AffineTransform tx) {
        this.transform = tx;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public boolean drawImage(final Image img, final int x, final int y, ImageObserver o) {
        this.drawMatrix2Canvas(new Runnable(){

            @Override
            public void run() {
                Graphics2D.this.canvas.drawBitmap(img.bm, (float)x, (float)y, Graphics2D.this.paint);
            }
        });
        return true;
    }

    public boolean drawImage(final Image image, final int x, final int y, final int width, final int height, ImageObserver o) {
        this.drawMatrix2Canvas(new Runnable(){

            @Override
            public void run() {
                Graphics2D.this.canvas.drawBitmap(image.bm, null, new Rect(x, y, x + width, y + height), Graphics2D.this.paint);
            }
        });
        return true;
    }

    public void setPaint(Color lineColor) {
        this.paint.setColor(lineColor.getRGB());
    }

    private void drawMatrix2Canvas(Runnable runnable) {
        this.canvas.save();
        this.canvas.setMatrix(this.matrix());
        runnable.run();
        this.canvas.restore();
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform at) {
        if (!(img instanceof BufferedImage)) {
            return;
        }
        Matrix m = new Matrix();
        float[] values = new float[9];
        values[0] = (float)at.getScaleX();
        values[4] = (float)at.getScaleY();
        values[2] = (float)at.getTranslateX();
        values[5] = (float)at.getTranslateY();
        values[1] = (float)at.getShearX();
        values[3] = (float)at.getShearY();
        values[8] = 1.0f;
        m.setValues(values);
        this.canvas.drawBitmap(((BufferedImage)img).bm, m, this.paint);
    }

    public void setPaint(Paint fill) {
        if (fill instanceof Color) {
            Color c = (Color)fill;
            this.paint.setColor(c.getRGB());
        }
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        int width = (int)((double)this.canvas.getWidth() - Math.ceil(x));
        new TextLayout(iterator, null, width <= 0 ? 1 : width).draw(this, x, y);
    }

    public Object getRenderingHint(RenderingHints.Key hint) {
        return this.hintMap.get(hint);
    }

    public void setRenderingHint(RenderingHints.Key hint, Object object) {
        XSLFRenderingHint xslfRenderingHint = this.getXSLFRenderingHint(hint);
        if (object.getClass() == Boolean.TYPE) {
            if (xslfRenderingHint == XSLFRenderingHint.GSAVE) {
                this.canvas.save();
            } else if (xslfRenderingHint == XSLFRenderingHint.GRESTORE) {
                this.canvas.restore();
            }
        }
        this.hintMap.put(hint, object);
    }

    private XSLFRenderingHint getXSLFRenderingHint(Object object) {
        if (object instanceof XSLFRenderingHint) {
            return (XSLFRenderingHint)object;
        }
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(null, false, false);
    }
}

