/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.java.awt;

import org.apache.poi.java.awt.Paint;
import org.apache.poi.java.awt.geom.Rectangle2D;
import org.apache.poi.java.awt.image.BufferedImage;

public class TexturePaint
implements Paint {
    BufferedImage bufImg;
    double tx;
    double ty;
    double sx;
    double sy;

    public TexturePaint(BufferedImage txtr, Rectangle2D anchor) {
        this.bufImg = txtr;
        this.tx = anchor.getX();
        this.ty = anchor.getY();
        this.sx = anchor.getWidth() / (double)this.bufImg.getWidth();
        this.sy = anchor.getHeight() / (double)this.bufImg.getHeight();
    }

    public BufferedImage getImage() {
        return this.bufImg;
    }

    public Rectangle2D getAnchorRect() {
        return new Rectangle2D.Double(this.tx, this.ty, this.sx * (double)this.bufImg.getWidth(), this.sy * (double)this.bufImg.getHeight());
    }

    @Override
    public int getTransparency() {
        return 1;
    }
}

