/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.java.awt.font;

import java.text.CharacterIterator;

class CharArrayIterator
implements CharacterIterator {
    private char[] chars;
    private int pos;
    private int begin;

    CharArrayIterator(char[] chars) {
        this.reset(chars, 0);
    }

    CharArrayIterator(char[] chars, int begin) {
        this.reset(chars, begin);
    }

    @Override
    public char first() {
        this.pos = 0;
        return this.current();
    }

    @Override
    public char last() {
        this.pos = this.chars.length > 0 ? this.chars.length - 1 : 0;
        return this.current();
    }

    @Override
    public char current() {
        if (this.pos >= 0 && this.pos < this.chars.length) {
            return this.chars[this.pos];
        }
        return '\uffff';
    }

    @Override
    public char next() {
        if (this.pos < this.chars.length - 1) {
            ++this.pos;
            return this.chars[this.pos];
        }
        this.pos = this.chars.length;
        return '\uffff';
    }

    @Override
    public char previous() {
        if (this.pos > 0) {
            --this.pos;
            return this.chars[this.pos];
        }
        this.pos = 0;
        return '\uffff';
    }

    @Override
    public char setIndex(int position) {
        if ((position -= this.begin) < 0 || position > this.chars.length) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.pos = position;
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return this.begin;
    }

    @Override
    public int getEndIndex() {
        return this.begin + this.chars.length;
    }

    @Override
    public int getIndex() {
        return this.begin + this.pos;
    }

    @Override
    public Object clone() {
        CharArrayIterator c = new CharArrayIterator(this.chars, this.begin);
        c.pos = this.pos;
        return c;
    }

    void reset(char[] chars) {
        this.reset(chars, 0);
    }

    void reset(char[] chars, int begin) {
        this.chars = chars;
        this.begin = begin;
        this.pos = 0;
    }
}

