/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.java.awt.font;

import java.text.AttributedCharacterIterator;
import org.apache.poi.java.awt.font.FontRenderContext;
import org.apache.poi.java.awt.font.TextLayout;

public class LineBreakMeasurer {
    private AttributedCharacterIterator aci;
    private FontRenderContext frc;
    private int pos;
    private int limit;

    public LineBreakMeasurer(AttributedCharacterIterator aci, FontRenderContext frc) {
        this.aci = aci;
        this.frc = frc;
        this.pos = aci.getBeginIndex();
        this.limit = aci.getEndIndex();
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int position) {
        if (position < 0 || position > this.limit) {
            return;
        }
        this.pos = position;
    }

    public TextLayout nextLayout(float wrappingWidth, int offsetLimit, boolean requireNextWord) {
        if (this.pos >= this.limit) {
            return null;
        }
        this.pos = this.limit;
        return new TextLayout(this.aci, this.frc, (int)wrappingWidth);
    }
}

