/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.java.awt.font;

import android.graphics.Canvas;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.SpannableString;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.poi.java.awt.Color;
import org.apache.poi.java.awt.Graphics2D;
import org.apache.poi.java.awt.Rectangle;
import org.apache.poi.java.awt.font.FontRenderContext;
import org.apache.poi.java.awt.font.TextAttribute;
import org.apache.poi.java.awt.geom.Rectangle2D;

public class TextLayout {
    private StaticLayout andTextLayout;
    private CharSequence text;
    private TextPaint paint;
    private float advance = -1.0f;

    public TextLayout(AttributedCharacterIterator aci, FontRenderContext frc) {
        this(aci, frc, 1);
    }

    public TextLayout(AttributedCharacterIterator aci, FontRenderContext frc, int width) {
        StringBuilder sb = new StringBuilder();
        char c = aci.first();
        while (c != '\uffff') {
            sb.append(c);
            c = aci.next();
        }
        String chars = sb.toString();
        SpannableString ss = new SpannableString((CharSequence)chars);
        TextPaint paint = new TextPaint();
        List<RangeValue<Float>> sizeValues = this.getRangeValues(aci, TextAttribute.SIZE, Float.class);
        if (sizeValues.size() == 1) {
            Float size = (Float)((RangeValue)sizeValues.get(0)).value;
            if (size != null) {
                paint.setTextSize(size.floatValue());
            }
        } else if (sizeValues.size() > 1) {
            Float maxSize = Float.valueOf(Float.MIN_VALUE);
            Float minSize = Float.valueOf(Float.MAX_VALUE);
            for (RangeValue<Float> rangeValue : sizeValues) {
                if (((RangeValue)rangeValue).value == null) continue;
                if (((Float)((RangeValue)rangeValue).value).floatValue() >= maxSize.floatValue()) {
                    maxSize = (Float)((RangeValue)rangeValue).value;
                }
                if (!(((Float)((RangeValue)rangeValue).value).floatValue() <= minSize.floatValue())) continue;
                minSize = (Float)((RangeValue)rangeValue).value;
            }
            paint.setTextSize(minSize.floatValue());
            if (!Objects.equals(maxSize, minSize)) {
                for (RangeValue<Float> rangeValue : sizeValues) {
                    Float value2 = (Float)((RangeValue)rangeValue).value;
                    if (value2 == null) continue;
                    ss.setSpan((Object)new RelativeSizeSpan(value2.floatValue() / minSize.floatValue()), ((RangeValue)rangeValue).startIndex, ((RangeValue)rangeValue).endIndex, 33);
                }
            }
        }
        List<RangeValue<Color>> foregroundValues = this.getRangeValues(aci, TextAttribute.FOREGROUND, Color.class);
        if (foregroundValues.size() == 1) {
            Color value3 = (Color)((RangeValue)foregroundValues.get(0)).value;
            if (value3 != null) {
                paint.setColor(value3.getRGB());
            }
        } else if (foregroundValues.size() > 1) {
            for (RangeValue rangeValue : foregroundValues) {
                Color color = (Color)rangeValue.value;
                if (color == null) continue;
                ss.setSpan((Object)new ForegroundColorSpan(color.getRGB()), rangeValue.startIndex, rangeValue.endIndex, 33);
            }
        }
        List<RangeValue<Integer>> underlineValues = this.getRangeValues(aci, TextAttribute.UNDERLINE, Integer.class);
        if (underlineValues.size() == 1) {
            Integer n = (Integer)((RangeValue)underlineValues.get(0)).value;
            if (Objects.equals(n, TextAttribute.UNDERLINE_ON)) {
                paint.setUnderlineText(true);
            }
        } else if (underlineValues.size() > 1) {
            for (RangeValue<Integer> rangeValue : underlineValues) {
                Integer value = (Integer)((RangeValue)rangeValue).value;
                if (!Objects.equals(value, TextAttribute.UNDERLINE_ON)) continue;
                ss.setSpan((Object)new UnderlineSpan(), ((RangeValue)rangeValue).startIndex, ((RangeValue)rangeValue).endIndex, 33);
            }
        }
        List<RangeValue<Float>> list = this.getRangeValues(aci, TextAttribute.WEIGHT, Float.class);
        if (list.size() == 1) {
            Float f = (Float)((RangeValue)list.get(0)).value;
            if (f != null && f.floatValue() >= TextAttribute.WEIGHT_BOLD.floatValue()) {
                paint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
            }
        } else if (list.size() > 1) {
            for (RangeValue<Float> rangeValue : list) {
                Float value5 = (Float)((RangeValue)rangeValue).value;
                if (value5 == null || !(value5.floatValue() >= TextAttribute.WEIGHT_BOLD.floatValue())) continue;
                ss.setSpan((Object)new StyleSpan(1), ((RangeValue)rangeValue).startIndex, ((RangeValue)rangeValue).endIndex, 33);
            }
        }
        this.text = ss;
        this.paint = paint;
        this.andTextLayout = new StaticLayout(this.text, paint, width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
    }

    private <T> List<RangeValue<T>> getRangeValues(AttributedCharacterIterator aci, TextAttribute attr, Class<T> clz) {
        ArrayList<RangeValue<T>> r = new ArrayList<RangeValue<T>>();
        int limit = aci.getEndIndex();
        int pos = aci.getBeginIndex();
        while (true) {
            aci.setIndex(pos);
            int attrLimit = aci.getRunLimit(attr);
            r.add(new RangeValue(pos, attrLimit, this.getAttribute(aci, attr, clz)));
            if (attrLimit >= limit) break;
            pos = attrLimit;
        }
        return r;
    }

    private <T> T getAttribute(AttributedCharacterIterator aci, TextAttribute attr, Class<T> clz) {
        Object attrValue = aci.getAttribute(attr);
        if (attrValue != null && clz.isAssignableFrom(attrValue.getClass())) {
            return (T)attrValue;
        }
        return null;
    }

    public TextLayout getJustifiedLayout(float justificationWidth) {
        int newWidth = (int)justificationWidth;
        if (newWidth != this.andTextLayout.getWidth()) {
            this.andTextLayout = new StaticLayout(this.text, this.paint, newWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        }
        return this;
    }

    public void draw(Graphics2D g2, float x, float y) {
        Canvas canvas = g2.canvas;
        canvas.save();
        canvas.translate(x, y);
        this.andTextLayout.draw(canvas);
        canvas.restore();
    }

    public float getAdvance() {
        if (this.advance < 0.0f) {
            float max = 0.0f;
            for (int i = 0; i < this.andTextLayout.getLineCount(); ++i) {
                float lineWidth = this.andTextLayout.getLineWidth(i);
                if (!(lineWidth > max)) continue;
                max = lineWidth;
            }
            this.advance = max;
        }
        return this.advance;
    }

    public float getAscent() {
        return 0.0f;
    }

    public float getDescent() {
        return this.andTextLayout.getHeight();
    }

    public float getLeading() {
        return this.paint.getFontMetrics().leading;
    }

    public Rectangle2D getBounds() {
        return new Rectangle(0, 0, this.andTextLayout.getWidth(), this.andTextLayout.getHeight());
    }

    private static class RangeValue<T> {
        private int startIndex;
        private int endIndex;
        private T value;

        private RangeValue(int startIndex, int endIndex, T value) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.value = value;
        }
    }
}

