/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.java.awt.geom;

import java.util.NoSuchElementException;
import org.apache.poi.java.awt.geom.AffineTransform;
import org.apache.poi.java.awt.geom.PathIterator;
import org.apache.poi.java.awt.geom.QuadCurve2D;

class QuadIterator
implements PathIterator {
    QuadCurve2D quad;
    AffineTransform affine;
    int index;

    QuadIterator(QuadCurve2D q, AffineTransform at) {
        this.quad = q;
        this.affine = at;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(float[] coords) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("quad iterator iterator out of bounds");
        }
        if (this.index == 0) {
            coords[0] = (float)this.quad.getX1();
            coords[1] = (float)this.quad.getY1();
            type = 0;
        } else {
            coords[0] = (float)this.quad.getCtrlX();
            coords[1] = (float)this.quad.getCtrlY();
            coords[2] = (float)this.quad.getX2();
            coords[3] = (float)this.quad.getY2();
            type = 2;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
        }
        return type;
    }

    @Override
    public int currentSegment(double[] coords) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("quad iterator iterator out of bounds");
        }
        if (this.index == 0) {
            coords[0] = this.quad.getX1();
            coords[1] = this.quad.getY1();
            type = 0;
        } else {
            coords[0] = this.quad.getCtrlX();
            coords[1] = this.quad.getCtrlY();
            coords[2] = this.quad.getX2();
            coords[3] = this.quad.getY2();
            type = 2;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
        }
        return type;
    }
}

