/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.java.awt.image;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import org.apache.poi.java.awt.Graphics2D;
import org.apache.poi.java.awt.Image;
import org.apache.poi.java.awt.image.RenderedImage;

public class BufferedImage
extends Image
implements RenderedImage {
    private static final Bitmap.Config TYPE_INT_RGB = Bitmap.Config.RGB_565;

    public BufferedImage(Bitmap bm) {
        super(bm);
    }

    public BufferedImage(int width, int height, int config) {
        this(width, height, TYPE_INT_RGB);
    }

    private BufferedImage(int width, int height, Bitmap.Config config) {
        super(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config));
    }

    public Image getScaledInstance(int width, int height, int hint) {
        return new Image(BufferedImage.imageScale(this.bm, width, height));
    }

    private static Bitmap imageScale(Bitmap bitmap, int dst_w, int dst_h) {
        int src_w = bitmap.getWidth();
        int src_h = bitmap.getHeight();
        float scale_w = (float)dst_w / (float)src_w;
        float scale_h = (float)dst_h / (float)src_h;
        Matrix matrix = new Matrix();
        matrix.postScale(scale_w, scale_h);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)src_w, (int)src_h, (Matrix)matrix, (boolean)true);
    }

    public Graphics2D createGraphics() {
        if (this.bm == null) {
            return null;
        }
        Canvas canvas = new Canvas(this.bm);
        return new Graphics2D(canvas);
    }
}

