/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.poi.java.awt.Dimension;
import org.apache.poi.java.awt.image.BufferedImage;
import org.apache.poi.javax.imageio.ImageIO;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImageUtils {
    private static final POILogger logger = POILogFactory.getLogger(ImageUtils.class);
    public static final int PIXEL_DPI = 96;

    public static Dimension getImageDimension(InputStream is, int type) {
        Dimension size = new Dimension();
        switch (type) {
            case 5: 
            case 6: 
            case 7: {
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream((Object)is);
                    Iterator i = ImageIO.getImageReaders((Object)iis);
                    ImageReader r = (ImageReader)i.next();
                    r.setInput(iis);
                    BufferedImage img = r.read(0);
                    int[] dpi = ImageUtils.getResolution(r);
                    if (dpi[0] == 0) {
                        dpi[0] = 96;
                    }
                    if (dpi[1] == 0) {
                        dpi[1] = 96;
                    }
                    size.width = img.getWidth() * 96 / dpi[0];
                    size.height = img.getHeight() * 96 / dpi[1];
                    r.dispose();
                    iis.close();
                }
                catch (IOException e) {
                    logger.log(5, e);
                }
                break;
            }
            default: {
                logger.log(5, "Only JPEG, PNG and DIB pictures can be automatically sized");
            }
        }
        return size;
    }

    public static int[] getResolution(ImageReader r) throws IOException {
        int hdpi = 96;
        int vdpi = 96;
        double mm2inch = 25.4;
        Element node = (Element)r.getImageMetadata(0).getAsTree("javax_imageio_1.0");
        NodeList lst = node.getElementsByTagName("HorizontalPixelSize");
        if (lst != null && lst.getLength() == 1) {
            hdpi = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
        }
        if ((lst = node.getElementsByTagName("VerticalPixelSize")) != null && lst.getLength() == 1) {
            vdpi = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
        }
        return new int[]{hdpi, vdpi};
    }
}

