/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.java.awt.Color;
import org.apache.poi.java.awt.Graphics2D;
import org.apache.poi.java.awt.Paint;
import org.apache.poi.java.awt.Shape;
import org.apache.poi.java.awt.geom.AffineTransform;
import org.apache.poi.java.awt.geom.Ellipse2D;
import org.apache.poi.java.awt.geom.GeneralPath;
import org.apache.poi.java.awt.geom.Rectangle2D;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.model.PropertyFetcher;
import org.apache.poi.xslf.model.geom.CustomGeometry;
import org.apache.poi.xslf.model.geom.Outline;
import org.apache.poi.xslf.model.geom.Path;
import org.apache.poi.xslf.model.geom.PresetGeometries;
import org.apache.poi.xslf.usermodel.LineCap;
import org.apache.poi.xslf.usermodel.LineDash;
import org.apache.poi.xslf.usermodel.LineDecoration;
import org.apache.poi.xslf.usermodel.LineEndLength;
import org.apache.poi.xslf.usermodel.LineEndWidth;
import org.apache.poi.xslf.usermodel.RenderableShape;
import org.apache.poi.xslf.usermodel.XSLFShadow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFShapeType;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTEffectStyleItem;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineEndProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOuterShadowEffect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetLineDashProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrix;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineCap;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndLength;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndType;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndWidth;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetLineDashVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLFSimpleShape
extends XSLFShape {
    private static CTOuterShadowEffect NO_SHADOW = CTOuterShadowEffect.Factory.newInstance();
    private final XmlObject _shape;
    private final XSLFSheet _sheet;
    private CTShapeProperties _spPr;
    private CTShapeStyle _spStyle;
    private CTNonVisualDrawingProps _nvPr;
    private CTPlaceholder _ph;

    XSLFSimpleShape(XmlObject shape, XSLFSheet sheet) {
        this._shape = shape;
        this._sheet = sheet;
    }

    @Override
    public XmlObject getXmlObject() {
        return this._shape;
    }

    public XSLFSheet getSheet() {
        return this._sheet;
    }

    public void setShapeType(XSLFShapeType type) {
        CTShape shape = (CTShape)this.getXmlObject();
        STShapeType.Enum geom = STShapeType.Enum.forInt(type.getIndex());
        shape.getSpPr().getPrstGeom().setPrst(geom);
    }

    public XSLFShapeType getShapeType() {
        CTShape shape = (CTShape)this.getXmlObject();
        STShapeType.Enum geom = shape.getSpPr().getPrstGeom().getPrst();
        return XSLFShapeType.forInt(geom.intValue());
    }

    @Override
    public String getShapeName() {
        return this.getNvPr().getName();
    }

    @Override
    public int getShapeId() {
        return (int)this.getNvPr().getId();
    }

    protected CTNonVisualDrawingProps getNvPr() {
        XmlObject[] rs;
        if (this._nvPr == null && (rs = this._shape.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:cNvPr")).length != 0) {
            this._nvPr = (CTNonVisualDrawingProps)rs[0];
        }
        return this._nvPr;
    }

    protected CTShapeProperties getSpPr() {
        if (this._spPr == null) {
            for (XmlObject obj : this._shape.selectPath("*")) {
                if (!(obj instanceof CTShapeProperties)) continue;
                this._spPr = (CTShapeProperties)obj;
            }
        }
        if (this._spPr == null) {
            throw new IllegalStateException("CTShapeProperties was not found.");
        }
        return this._spPr;
    }

    protected CTShapeStyle getSpStyle() {
        if (this._spStyle == null) {
            for (XmlObject obj : this._shape.selectPath("*")) {
                if (!(obj instanceof CTShapeStyle)) continue;
                this._spStyle = (CTShapeStyle)obj;
            }
        }
        return this._spStyle;
    }

    protected CTPlaceholder getCTPlaceholder() {
        XmlObject[] obj;
        if (this._ph == null && (obj = this._shape.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:nvPr/p:ph")).length == 1) {
            this._ph = (CTPlaceholder)obj[0];
        }
        return this._ph;
    }

    CTTransform2D getXfrm() {
        PropertyFetcher<CTTransform2D> fetcher = new PropertyFetcher<CTTransform2D>(){

            @Override
            public boolean fetch(XSLFSimpleShape shape) {
                CTShapeProperties pr = shape.getSpPr();
                if (pr.isSetXfrm()) {
                    this.setValue(pr.getXfrm());
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return (CTTransform2D)fetcher.getValue();
    }

    @Override
    public Rectangle2D getAnchor() {
        CTTransform2D xfrm = this.getXfrm();
        CTPoint2D off = xfrm.getOff();
        long x = off.getX();
        long y = off.getY();
        CTPositiveSize2D ext = xfrm.getExt();
        long cx = ext.getCx();
        long cy = ext.getCy();
        return new Rectangle2D.Double(Units.toPoints(x), Units.toPoints(y), Units.toPoints(cx), Units.toPoints(cy));
    }

    @Override
    public void setAnchor(Rectangle2D anchor) {
        CTShapeProperties spPr = this.getSpPr();
        CTTransform2D xfrm = spPr.isSetXfrm() ? spPr.getXfrm() : spPr.addNewXfrm();
        CTPoint2D off = xfrm.isSetOff() ? xfrm.getOff() : xfrm.addNewOff();
        long x = Units.toEMU(anchor.getX());
        long y = Units.toEMU(anchor.getY());
        off.setX(x);
        off.setY(y);
        CTPositiveSize2D ext = xfrm.isSetExt() ? xfrm.getExt() : xfrm.addNewExt();
        long cx = Units.toEMU(anchor.getWidth());
        long cy = Units.toEMU(anchor.getHeight());
        ext.setCx(cx);
        ext.setCy(cy);
    }

    @Override
    public void setRotation(double theta) {
        CTShapeProperties spPr = this.getSpPr();
        CTTransform2D xfrm = spPr.isSetXfrm() ? spPr.getXfrm() : spPr.addNewXfrm();
        xfrm.setRot((int)(theta * 60000.0));
    }

    @Override
    public double getRotation() {
        CTTransform2D xfrm = this.getXfrm();
        return (double)xfrm.getRot() / 60000.0;
    }

    @Override
    public void setFlipHorizontal(boolean flip) {
        CTShapeProperties spPr = this.getSpPr();
        CTTransform2D xfrm = spPr.isSetXfrm() ? spPr.getXfrm() : spPr.addNewXfrm();
        xfrm.setFlipH(flip);
    }

    @Override
    public void setFlipVertical(boolean flip) {
        CTShapeProperties spPr = this.getSpPr();
        CTTransform2D xfrm = spPr.isSetXfrm() ? spPr.getXfrm() : spPr.addNewXfrm();
        xfrm.setFlipV(flip);
    }

    @Override
    public boolean getFlipHorizontal() {
        return this.getXfrm().getFlipH();
    }

    @Override
    public boolean getFlipVertical() {
        return this.getXfrm().getFlipV();
    }

    CTLineProperties getDefaultLineProperties() {
        CTLineProperties ln = null;
        CTShapeStyle style = this.getSpStyle();
        if (style != null) {
            int idx = (int)style.getLnRef().getIdx();
            CTStyleMatrix styleMatrix = this._sheet.getTheme().getXmlObject().getThemeElements().getFmtScheme();
            ln = styleMatrix.getLnStyleLst().getLnArray(idx - 1);
        }
        return ln;
    }

    public void setLineColor(Color color) {
        CTShapeProperties spPr = this.getSpPr();
        if (color == null) {
            if (spPr.isSetLn() && spPr.getLn().isSetSolidFill()) {
                spPr.getLn().unsetSolidFill();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
            rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            CTSolidColorFillProperties fill = ln.isSetSolidFill() ? ln.getSolidFill() : ln.addNewSolidFill();
            fill.setSrgbClr(rgb);
            if (fill.isSetHslClr()) {
                fill.unsetHslClr();
            }
            if (fill.isSetPrstClr()) {
                fill.unsetPrstClr();
            }
            if (fill.isSetSchemeClr()) {
                fill.unsetSchemeClr();
            }
            if (fill.isSetScrgbClr()) {
                fill.unsetScrgbClr();
            }
            if (fill.isSetSysClr()) {
                fill.unsetSysClr();
            }
        }
    }

    public Color getLineColor() {
        RenderableShape rShape = new RenderableShape(this);
        Paint paint = rShape.getLinePaint(null);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return null;
    }

    public void setLineWidth(double width) {
        CTShapeProperties spPr = this.getSpPr();
        if (width == 0.0) {
            if (spPr.isSetLn() && spPr.getLn().isSetW()) {
                spPr.getLn().unsetW();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            ln.setW(Units.toEMU(width));
        }
    }

    public double getLineWidth() {
        PropertyFetcher<Double> fetcher = new PropertyFetcher<Double>(){

            @Override
            public boolean fetch(XSLFSimpleShape shape) {
                CTShapeProperties spPr = shape.getSpPr();
                CTLineProperties ln = spPr.getLn();
                if (ln != null) {
                    if (ln.isSetNoFill()) {
                        this.setValue(0.0);
                        return true;
                    }
                    if (ln.isSetW()) {
                        this.setValue(Units.toPoints(ln.getW()));
                        return true;
                    }
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        double lineWidth = 0.0;
        if (fetcher.getValue() == null) {
            CTLineProperties defaultLn = this.getDefaultLineProperties();
            if (defaultLn != null && defaultLn.isSetW()) {
                lineWidth = Units.toPoints(defaultLn.getW());
            }
        } else {
            lineWidth = (Double)fetcher.getValue();
        }
        return lineWidth;
    }

    public void setLineDash(LineDash dash) {
        CTShapeProperties spPr = this.getSpPr();
        if (dash == null) {
            if (spPr.isSetLn() && spPr.getLn().isSetPrstDash()) {
                spPr.getLn().unsetPrstDash();
            }
        } else {
            CTPresetLineDashProperties val = CTPresetLineDashProperties.Factory.newInstance();
            val.setVal(STPresetLineDashVal.Enum.forInt(dash.ordinal() + 1));
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            ln.setPrstDash(val);
        }
    }

    public LineDash getLineDash() {
        CTPresetLineDashProperties ctDash;
        CTLineProperties defaultLn;
        PropertyFetcher<LineDash> fetcher = new PropertyFetcher<LineDash>(){

            @Override
            public boolean fetch(XSLFSimpleShape shape) {
                CTPresetLineDashProperties ctDash;
                CTShapeProperties spPr = shape.getSpPr();
                CTLineProperties ln = spPr.getLn();
                if (ln != null && (ctDash = ln.getPrstDash()) != null) {
                    this.setValue(LineDash.values()[ctDash.getVal().intValue() - 1]);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        LineDash dash = (LineDash)((Object)fetcher.getValue());
        if (dash == null && (defaultLn = this.getDefaultLineProperties()) != null && (ctDash = defaultLn.getPrstDash()) != null) {
            dash = LineDash.values()[ctDash.getVal().intValue() - 1];
        }
        return dash;
    }

    public void setLineCap(LineCap cap) {
        CTShapeProperties spPr = this.getSpPr();
        if (cap == null) {
            if (spPr.isSetLn() && spPr.getLn().isSetCap()) {
                spPr.getLn().unsetCap();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            ln.setCap(STLineCap.Enum.forInt(cap.ordinal() + 1));
        }
    }

    public LineCap getLineCap() {
        STLineCap.Enum stCap;
        CTLineProperties defaultLn;
        PropertyFetcher<LineCap> fetcher = new PropertyFetcher<LineCap>(){

            @Override
            public boolean fetch(XSLFSimpleShape shape) {
                STLineCap.Enum stCap;
                CTShapeProperties spPr = shape.getSpPr();
                CTLineProperties ln = spPr.getLn();
                if (ln != null && (stCap = ln.getCap()) != null) {
                    this.setValue(LineCap.values()[stCap.intValue() - 1]);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        LineCap cap = (LineCap)((Object)fetcher.getValue());
        if (cap == null && (defaultLn = this.getDefaultLineProperties()) != null && (stCap = defaultLn.getCap()) != null) {
            cap = LineCap.values()[stCap.intValue() - 1];
        }
        return cap;
    }

    public void setFillColor(Color color) {
        CTShapeProperties spPr = this.getSpPr();
        if (color == null) {
            if (spPr.isSetSolidFill()) {
                spPr.unsetSolidFill();
            }
            if (!spPr.isSetNoFill()) {
                spPr.addNewNoFill();
            }
        } else {
            if (spPr.isSetNoFill()) {
                spPr.unsetNoFill();
            }
            CTSolidColorFillProperties fill = spPr.isSetSolidFill() ? spPr.getSolidFill() : spPr.addNewSolidFill();
            CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
            rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            fill.setSrgbClr(rgb);
            if (fill.isSetHslClr()) {
                fill.unsetHslClr();
            }
            if (fill.isSetPrstClr()) {
                fill.unsetPrstClr();
            }
            if (fill.isSetSchemeClr()) {
                fill.unsetSchemeClr();
            }
            if (fill.isSetScrgbClr()) {
                fill.unsetScrgbClr();
            }
            if (fill.isSetSysClr()) {
                fill.unsetSysClr();
            }
        }
    }

    public Color getFillColor() {
        RenderableShape rShape = new RenderableShape(this);
        Paint paint = rShape.getFillPaint(null);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return null;
    }

    public XSLFShadow getShadow() {
        int idx;
        CTShapeStyle style;
        PropertyFetcher<CTOuterShadowEffect> fetcher = new PropertyFetcher<CTOuterShadowEffect>(){

            @Override
            public boolean fetch(XSLFSimpleShape shape) {
                CTShapeProperties spPr = shape.getSpPr();
                if (spPr.isSetEffectLst()) {
                    CTOuterShadowEffect obj = spPr.getEffectLst().getOuterShdw();
                    this.setValue(obj == null ? NO_SHADOW : obj);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        CTOuterShadowEffect obj = (CTOuterShadowEffect)fetcher.getValue();
        if (obj == null && (style = this.getSpStyle()) != null && (idx = (int)style.getEffectRef().getIdx()) != 0) {
            CTStyleMatrix styleMatrix = this._sheet.getTheme().getXmlObject().getThemeElements().getFmtScheme();
            CTEffectStyleItem ef = styleMatrix.getEffectStyleLst().getEffectStyleArray(idx - 1);
            obj = ef.getEffectLst().getOuterShdw();
        }
        return obj == null || obj == NO_SHADOW ? null : new XSLFShadow(obj, this);
    }

    @Override
    public void draw(Graphics2D graphics) {
        RenderableShape rShape = new RenderableShape(this);
        rShape.render(graphics);
        Color lineColor = this.getLineColor();
        if (lineColor != null) {
            graphics.setPaint((Paint)lineColor);
            for (Outline o : this.getDecorationOutlines(graphics)) {
                if (o.getPath().isFilled()) {
                    graphics.fill(o.getOutline());
                }
                if (!o.getPath().isStroked()) continue;
                graphics.draw(o.getOutline());
            }
        }
    }

    boolean fetchShapeProperty(PropertyFetcher visitor) {
        boolean ok = visitor.fetch(this);
        XSLFSheet masterSheet = this.getSheet().getMasterSheet();
        CTPlaceholder ph = this.getCTPlaceholder();
        if (masterSheet != null && ph != null) {
            XSLFSimpleShape masterShape;
            if (!ok && (masterShape = masterSheet.getPlaceholder(ph)) != null) {
                ok = visitor.fetch(masterShape);
            }
            if (!ok) {
                int textType;
                if (!ph.isSetType()) {
                    textType = 2;
                } else {
                    switch (ph.getType().intValue()) {
                        case 1: 
                        case 3: {
                            textType = 1;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            textType = ph.getType().intValue();
                            break;
                        }
                        default: {
                            textType = 2;
                        }
                    }
                }
                XSLFSheet master = masterSheet.getMasterSheet();
                if (master != null && (masterShape = master.getPlaceholderByType(textType)) != null) {
                    ok = visitor.fetch(masterShape);
                }
            }
        }
        return ok;
    }

    CustomGeometry getGeometry() {
        CustomGeometry geom;
        CTShapeProperties spPr = this.getSpPr();
        PresetGeometries dict = PresetGeometries.getInstance();
        if (spPr.isSetPrstGeom()) {
            String name = spPr.getPrstGeom().getPrst().toString();
            geom = (CustomGeometry)dict.get(name);
            if (geom == null) {
                throw new IllegalStateException("Unknown shape geometry: " + name);
            }
        } else {
            geom = spPr.isSetCustGeom() ? new CustomGeometry(spPr.getCustGeom()) : (CustomGeometry)dict.get("rect");
        }
        return geom;
    }

    public void drawContent(Graphics2D graphics) {
    }

    @Override
    void copy(XSLFShape sh) {
        double tgtLineWidth;
        double srcLineWidth;
        super.copy(sh);
        XSLFSimpleShape s = (XSLFSimpleShape)sh;
        Color srsSolidFill = s.getFillColor();
        Color tgtSoliFill = this.getFillColor();
        if (srsSolidFill != null && !srsSolidFill.equals(tgtSoliFill)) {
            this.setFillColor(srsSolidFill);
        }
        if (this.getSpPr().isSetBlipFill()) {
            CTBlip blip = this.getSpPr().getBlipFill().getBlip();
            String blipId = blip.getEmbed();
            String relId = this.getSheet().importBlip(blipId, s.getSheet().getPackagePart());
            blip.setEmbed(relId);
        }
        Color srcLineColor = s.getLineColor();
        Color tgtLineColor = this.getLineColor();
        if (srcLineColor != null && !srcLineColor.equals(tgtLineColor)) {
            this.setLineColor(srcLineColor);
        }
        if ((srcLineWidth = s.getLineWidth()) != (tgtLineWidth = this.getLineWidth())) {
            this.setLineWidth(srcLineWidth);
        }
        LineDash srcLineDash = s.getLineDash();
        LineDash tgtLineDash = this.getLineDash();
        if (srcLineDash != null && srcLineDash != tgtLineDash) {
            this.setLineDash(srcLineDash);
        }
        LineCap srcLineCap = s.getLineCap();
        LineCap tgtLineCap = this.getLineCap();
        if (srcLineCap != null && srcLineCap != tgtLineCap) {
            this.setLineCap(srcLineCap);
        }
    }

    public void setLineHeadDecoration(LineDecoration style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetHeadEnd() ? ln.getHeadEnd() : ln.addNewHeadEnd();
        if (style == null) {
            if (lnEnd.isSetType()) {
                lnEnd.unsetType();
            }
        } else {
            lnEnd.setType(STLineEndType.Enum.forInt(style.ordinal() + 1));
        }
    }

    public LineDecoration getLineHeadDecoration() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetHeadEnd()) {
            return LineDecoration.NONE;
        }
        STLineEndType.Enum end = ln.getHeadEnd().getType();
        return end == null ? LineDecoration.NONE : LineDecoration.values()[end.intValue() - 1];
    }

    public void setLineHeadWidth(LineEndWidth style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetHeadEnd() ? ln.getHeadEnd() : ln.addNewHeadEnd();
        if (style == null) {
            if (lnEnd.isSetW()) {
                lnEnd.unsetW();
            }
        } else {
            lnEnd.setW(STLineEndWidth.Enum.forInt(style.ordinal() + 1));
        }
    }

    public LineEndWidth getLineHeadWidth() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetHeadEnd()) {
            return LineEndWidth.MEDIUM;
        }
        STLineEndWidth.Enum w = ln.getHeadEnd().getW();
        return w == null ? LineEndWidth.MEDIUM : LineEndWidth.values()[w.intValue() - 1];
    }

    public void setLineHeadLength(LineEndLength style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetHeadEnd() ? ln.getHeadEnd() : ln.addNewHeadEnd();
        if (style == null) {
            if (lnEnd.isSetLen()) {
                lnEnd.unsetLen();
            }
        } else {
            lnEnd.setLen(STLineEndLength.Enum.forInt(style.ordinal() + 1));
        }
    }

    public LineEndLength getLineHeadLength() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetHeadEnd()) {
            return LineEndLength.MEDIUM;
        }
        STLineEndLength.Enum len = ln.getHeadEnd().getLen();
        return len == null ? LineEndLength.MEDIUM : LineEndLength.values()[len.intValue() - 1];
    }

    public void setLineTailDecoration(LineDecoration style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetTailEnd() ? ln.getTailEnd() : ln.addNewTailEnd();
        if (style == null) {
            if (lnEnd.isSetType()) {
                lnEnd.unsetType();
            }
        } else {
            lnEnd.setType(STLineEndType.Enum.forInt(style.ordinal() + 1));
        }
    }

    public LineDecoration getLineTailDecoration() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetTailEnd()) {
            return LineDecoration.NONE;
        }
        STLineEndType.Enum end = ln.getTailEnd().getType();
        return end == null ? LineDecoration.NONE : LineDecoration.values()[end.intValue() - 1];
    }

    public void setLineTailWidth(LineEndWidth style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetTailEnd() ? ln.getTailEnd() : ln.addNewTailEnd();
        if (style == null) {
            if (lnEnd.isSetW()) {
                lnEnd.unsetW();
            }
        } else {
            lnEnd.setW(STLineEndWidth.Enum.forInt(style.ordinal() + 1));
        }
    }

    public LineEndWidth getLineTailWidth() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetTailEnd()) {
            return LineEndWidth.MEDIUM;
        }
        STLineEndWidth.Enum w = ln.getTailEnd().getW();
        return w == null ? LineEndWidth.MEDIUM : LineEndWidth.values()[w.intValue() - 1];
    }

    public void setLineTailLength(LineEndLength style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetTailEnd() ? ln.getTailEnd() : ln.addNewTailEnd();
        if (style == null) {
            if (lnEnd.isSetLen()) {
                lnEnd.unsetLen();
            }
        } else {
            lnEnd.setLen(STLineEndLength.Enum.forInt(style.ordinal() + 1));
        }
    }

    public LineEndLength getLineTailLength() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetTailEnd()) {
            return LineEndLength.MEDIUM;
        }
        STLineEndLength.Enum len = ln.getTailEnd().getLen();
        return len == null ? LineEndLength.MEDIUM : LineEndLength.values()[len.intValue() - 1];
    }

    Outline getTailDecoration(Graphics2D graphics) {
        LineEndLength tailLength = this.getLineTailLength();
        LineEndWidth tailWidth = this.getLineTailWidth();
        double lineWidth = Math.max(2.5, this.getLineWidth());
        Rectangle2D anchor = new RenderableShape(this).getAnchor(graphics);
        double x2 = anchor.getX() + anchor.getWidth();
        double y2 = anchor.getY() + anchor.getHeight();
        double alpha = Math.atan(anchor.getHeight() / anchor.getWidth());
        AffineTransform at = new AffineTransform();
        Shape shape = null;
        Path p = null;
        double scaleY = Math.pow(2.0, tailWidth.ordinal());
        double scaleX = Math.pow(2.0, tailLength.ordinal());
        switch (this.getLineTailDecoration()) {
            case OVAL: {
                p = new Path();
                shape = new Ellipse2D.Double(0.0, 0.0, lineWidth * scaleX, lineWidth * scaleY);
                Rectangle2D bounds = shape.getBounds2D();
                at.translate(x2 - bounds.getWidth() / 2.0, y2 - bounds.getHeight() / 2.0);
                at.rotate(alpha, bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
                break;
            }
            case ARROW: {
                p = new Path();
                GeneralPath arrow = new GeneralPath();
                arrow.moveTo((float)(-lineWidth * 3.0), (float)(-lineWidth * 2.0));
                arrow.lineTo(0.0f, 0.0f);
                arrow.lineTo((float)(-lineWidth * 3.0), (float)(lineWidth * 2.0));
                shape = arrow;
                at.translate(x2, y2);
                at.rotate(alpha);
                break;
            }
            case TRIANGLE: {
                p = new Path();
                scaleY = tailWidth.ordinal() + 1;
                scaleX = tailLength.ordinal() + 1;
                GeneralPath triangle = new GeneralPath();
                triangle.moveTo((float)(-lineWidth * scaleX), (float)(-lineWidth * scaleY / 2.0));
                triangle.lineTo(0.0f, 0.0f);
                triangle.lineTo((float)(-lineWidth * scaleX), (float)(lineWidth * scaleY / 2.0));
                triangle.closePath();
                shape = triangle;
                at.translate(x2, y2);
                at.rotate(alpha);
                break;
            }
        }
        if (shape != null) {
            shape = at.createTransformedShape(shape);
        }
        return shape == null ? null : new Outline(shape, p);
    }

    Outline getHeadDecoration(Graphics2D graphics) {
        LineEndLength headLength = this.getLineHeadLength();
        LineEndWidth headWidth = this.getLineHeadWidth();
        double lineWidth = Math.max(2.5, this.getLineWidth());
        Rectangle2D anchor = new RenderableShape(this).getAnchor(graphics);
        double x1 = anchor.getX();
        double y1 = anchor.getY();
        double alpha = Math.atan(anchor.getHeight() / anchor.getWidth());
        AffineTransform at = new AffineTransform();
        Shape shape = null;
        Path p = null;
        double scaleY = 1.0;
        double scaleX = 1.0;
        switch (this.getLineHeadDecoration()) {
            case OVAL: {
                p = new Path();
                shape = new Ellipse2D.Double(0.0, 0.0, lineWidth * scaleX, lineWidth * scaleY);
                Rectangle2D bounds = shape.getBounds2D();
                at.translate(x1 - bounds.getWidth() / 2.0, y1 - bounds.getHeight() / 2.0);
                at.rotate(alpha, bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
                break;
            }
            case ARROW: 
            case STEALTH: {
                p = new Path(false, true);
                GeneralPath arrow = new GeneralPath();
                arrow.moveTo((float)(lineWidth * 3.0 * scaleX), (float)(-lineWidth * scaleY * 2.0));
                arrow.lineTo(0.0f, 0.0f);
                arrow.lineTo((float)(lineWidth * 3.0 * scaleX), (float)(lineWidth * scaleY * 2.0));
                shape = arrow;
                at.translate(x1, y1);
                at.rotate(alpha);
                break;
            }
            case TRIANGLE: {
                p = new Path();
                scaleY = headWidth.ordinal() + 1;
                scaleX = headLength.ordinal() + 1;
                GeneralPath triangle = new GeneralPath();
                triangle.moveTo((float)(lineWidth * scaleX), (float)(-lineWidth * scaleY / 2.0));
                triangle.lineTo(0.0f, 0.0f);
                triangle.lineTo((float)(lineWidth * scaleX), (float)(lineWidth * scaleY / 2.0));
                triangle.closePath();
                shape = triangle;
                at.translate(x1, y1);
                at.rotate(alpha);
                break;
            }
        }
        if (shape != null) {
            shape = at.createTransformedShape(shape);
        }
        return shape == null ? null : new Outline(shape, p);
    }

    private List<Outline> getDecorationOutlines(Graphics2D graphics) {
        Outline tail;
        ArrayList<Outline> lst = new ArrayList<Outline>();
        Outline head = this.getHeadDecoration(graphics);
        if (head != null) {
            lst.add(head);
        }
        if ((tail = this.getTailDecoration(graphics)) != null) {
            lst.add(tail);
        }
        return lst;
    }
}

