/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.IOException;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.java.awt.Graphics2D;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xslf.usermodel.Placeholder;
import org.apache.poi.xslf.usermodel.XSLFBackground;
import org.apache.poi.xslf.usermodel.XSLFComments;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShapeNonVisual;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.SldDocument;

public final class XSLFSlide
extends XSLFSheet {
    private final CTSlide _slide;
    private XSLFSlideLayout _layout;
    private XSLFComments _comments;
    private XSLFNotes _notes;

    XSLFSlide() {
        this._slide = XSLFSlide.prototype();
        this.setCommonSlideData(this._slide.getCSld());
    }

    XSLFSlide(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        super(part, rel);
        SldDocument doc = SldDocument.Factory.parse(this.getPackagePart().getInputStream());
        this._slide = doc.getSld();
        this.setCommonSlideData(this._slide.getCSld());
    }

    private static CTSlide prototype() {
        CTSlide ctSlide = CTSlide.Factory.newInstance();
        CTCommonSlideData cSld = ctSlide.addNewCSld();
        CTGroupShape spTree = cSld.addNewSpTree();
        CTGroupShapeNonVisual nvGrpSpPr = spTree.addNewNvGrpSpPr();
        CTNonVisualDrawingProps cnvPr = nvGrpSpPr.addNewCNvPr();
        cnvPr.setId(1L);
        cnvPr.setName("");
        nvGrpSpPr.addNewCNvGrpSpPr();
        nvGrpSpPr.addNewNvPr();
        CTGroupShapeProperties grpSpr = spTree.addNewGrpSpPr();
        CTGroupTransform2D xfrm = grpSpr.addNewXfrm();
        CTPoint2D off = xfrm.addNewOff();
        off.setX(0L);
        off.setY(0L);
        CTPositiveSize2D ext = xfrm.addNewExt();
        ext.setCx(0L);
        ext.setCy(0L);
        CTPoint2D choff = xfrm.addNewChOff();
        choff.setX(0L);
        choff.setY(0L);
        CTPositiveSize2D chExt = xfrm.addNewChExt();
        chExt.setCx(0L);
        chExt.setCy(0L);
        ctSlide.addNewClrMapOvr().addNewMasterClrMapping();
        return ctSlide;
    }

    public CTSlide getXmlObject() {
        return this._slide;
    }

    protected String getRootElementName() {
        return "sld";
    }

    public XSLFSlideLayout getMasterSheet() {
        return this.getSlideLayout();
    }

    public XSLFSlideLayout getSlideLayout() {
        if (this._layout == null) {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSLFSlideLayout)) continue;
                this._layout = (XSLFSlideLayout)p;
            }
        }
        if (this._layout == null) {
            throw new IllegalArgumentException("SlideLayout was not found for " + this.toString());
        }
        return this._layout;
    }

    public XSLFSlideMaster getSlideMaster() {
        return this.getSlideLayout().getSlideMaster();
    }

    public XSLFComments getComments() {
        if (this._comments == null) {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSLFComments)) continue;
                this._comments = (XSLFComments)p;
            }
        }
        if (this._comments == null) {
            return null;
        }
        return this._comments;
    }

    public XSLFNotes getNotes() {
        if (this._notes == null) {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSLFNotes)) continue;
                this._notes = (XSLFNotes)p;
            }
        }
        if (this._notes == null) {
            return null;
        }
        return this._notes;
    }

    public String getTitle() {
        XSLFTextShape txt = this.getTextShapeByType(Placeholder.TITLE);
        return txt == null ? "" : txt.getText();
    }

    public XSLFTheme getTheme() {
        return this.getSlideLayout().getSlideMaster().getTheme();
    }

    public XSLFBackground getBackground() {
        CTBackground bg = this._slide.getCSld().getBg();
        if (bg != null) {
            return new XSLFBackground(bg, (XSLFSheet)this);
        }
        return this.getMasterSheet().getBackground();
    }

    public boolean getFollowMasterGraphics() {
        return !this._slide.isSetShowMasterSp() || this._slide.getShowMasterSp();
    }

    public void setFollowMasterGraphics(boolean value) {
        this._slide.setShowMasterSp(value);
    }

    public void draw(Graphics2D graphics) {
        XSLFBackground bg = this.getBackground();
        if (bg != null) {
            bg.draw(graphics);
        }
        super.draw(graphics);
    }

    public XSLFSlide importContent(XSLFSheet src) {
        CTBackground bg;
        super.importContent(src);
        XSLFBackground bgShape = this.getBackground();
        if (bgShape != null && (bg = (CTBackground)bgShape.getXmlObject()).isSetBgPr() && bg.getBgPr().isSetBlipFill()) {
            CTBlip blip = bg.getBgPr().getBlipFill().getBlip();
            String blipId = blip.getEmbed();
            String relId = this.importBlip(blipId, src.getPackagePart());
            blip.setEmbed(relId);
        }
        return this;
    }
}

