/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.poi.java.awt.Color;
import org.apache.poi.java.awt.Dimension;
import org.apache.poi.java.awt.Graphics2D;
import org.apache.poi.java.awt.RenderingHints;
import org.apache.poi.java.awt.image.BufferedImage;
import org.apache.poi.java.awt.image.RenderedImage;
import org.apache.poi.javax.imageio.ImageIO;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;

public class PPTX2PNG {
    static void usage() {
        System.out.println("Usage: PPTX2PNG [options] <pptx file>");
        System.out.println("Options:");
        System.out.println("    -scale <float>   scale factor");
        System.out.println("    -slide <integer> 1-based index of a slide to render");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            PPTX2PNG.usage();
            return;
        }
        int slidenum = -1;
        float scale = 1.0f;
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if ("-scale".equals(args[i])) {
                    scale = Float.parseFloat(args[++i]);
                    continue;
                }
                if (!"-slide".equals(args[i])) continue;
                slidenum = Integer.parseInt(args[++i]);
                continue;
            }
            file = args[i];
        }
        if (file == null) {
            PPTX2PNG.usage();
            return;
        }
        System.out.println("Processing " + file);
        XMLSlideShow ppt = new XMLSlideShow(OPCPackage.open(file));
        Dimension pgsize = ppt.getPageSize();
        int width = (int)((float)pgsize.width * scale);
        int height = (int)((float)pgsize.height * scale);
        XSLFSlide[] slide = ppt.getSlides();
        for (int i = 0; i < slide.length; ++i) {
            if (slidenum != -1 && slidenum != i + 1) continue;
            String title = slide[i].getTitle();
            System.out.println("Rendering slide " + (i + 1) + (title == null ? "" : ": " + title));
            BufferedImage img = new BufferedImage(width, height, 1);
            Graphics2D graphics = img.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics.setColor(Color.white);
            graphics.clearRect(0, 0, width, height);
            graphics.scale(scale, scale);
            slide[i].draw(graphics);
            int sep = file.lastIndexOf(".");
            String fname = file.substring(0, sep == -1 ? file.length() : sep) + "-" + (i + 1) + ".png";
            FileOutputStream out = new FileOutputStream(fname);
            ImageIO.write((RenderedImage)img, (String)"png", (OutputStream)out);
            out.close();
        }
        System.out.println("Done");
    }
}

