/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.openxmlformats;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.converter.core.IImageExtractor;
import org.apache.poi.xwpf.converter.core.IMasterPageHandler;
import org.apache.poi.xwpf.converter.core.IXWPFMasterPage;
import org.apache.poi.xwpf.converter.core.ListItemContext;
import org.apache.poi.xwpf.converter.core.MasterPageManager;
import org.apache.poi.xwpf.converter.core.Options;
import org.apache.poi.xwpf.converter.core.openxmlformats.IOpenXMLFormatsPartProvider;
import org.apache.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import org.apache.poi.xwpf.converter.core.utils.DxaUtil;
import org.apache.poi.xwpf.converter.core.utils.StringUtils;
import org.apache.poi.xwpf.converter.core.utils.XWPFRunHelper;
import org.apache.poi.xwpf.converter.core.utils.XWPFTableUtil;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlTokenSource;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTPosH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTPosV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTWrapSquare;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STWrapText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTEmpty;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPTab;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRunTrackChange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSmartTagRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabs;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FtrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenXMlFormatsVisitor<T, O extends Options, E extends IXWPFMasterPage>
implements IMasterPageHandler<E> {
    private final IOpenXMLFormatsPartProvider provider;
    protected final O options;
    private final CTDocument1 document;
    private final MasterPageManager masterPageManager;
    private CTHdrFtr currentHeader;
    private CTHdrFtrRef currentHeaderRef;
    private CTHdrFtr currentFooter;
    private CTHdrFtrRef currentFooterRef;
    private boolean pageBreakOnNextParagraph;
    protected final XWPFStylesDocument stylesDocument;
    private final Stack<CTTbl> tables;

    public OpenXMlFormatsVisitor(IOpenXMLFormatsPartProvider provider, O options) throws Exception {
        this.provider = provider;
        this.options = options;
        this.tables = new Stack();
        this.document = provider.getDocument();
        this.stylesDocument = this.createStylesDocument(provider);
        this.masterPageManager = new MasterPageManager(this.document, this);
    }

    protected XWPFStylesDocument createStylesDocument(IOpenXMLFormatsPartProvider provider) throws Exception {
        return new XWPFStylesDocument(provider);
    }

    @Override
    public XWPFStylesDocument getStylesDocument() {
        return this.stylesDocument;
    }

    public O getOptions() {
        return this.options;
    }

    public MasterPageManager getMasterPageManager() {
        return this.masterPageManager;
    }

    public void start() throws Exception {
        T container = this.startVisitDocument();
        this.visitBodyElements(this.document, container);
        this.endVisitDocument();
    }

    protected abstract T startVisitDocument() throws Exception;

    protected abstract void endVisitDocument() throws Exception;

    private void visitBodyElements(CTDocument1 document, T container) throws Exception {
        this.visitBodyElements(document.getBody(), container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitBodyElements(XmlTokenSource token, T container) throws Exception {
        if (!this.masterPageManager.isInitialized()) {
            this.masterPageManager.initialize();
        }
        int i = 0;
        XmlCursor cursor = null;
        try {
            cursor = token.newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                CTSdtBlock block;
                CTSdtContentBlock contentBlock;
                XmlObject o = cursor.getObject();
                if (o instanceof CTP) {
                    this.visitParagraph((CTP)o, i, container);
                    ++i;
                    continue;
                }
                if (o instanceof CTTbl) {
                    this.visitTable((CTTbl)o, i, container);
                    ++i;
                    continue;
                }
                if (!(o instanceof CTSdtBlock) || (contentBlock = (block = (CTSdtBlock)o).getSdtContent()) == null) continue;
                this.visitBodyElements(contentBlock, container);
            }
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    protected void visitParagraph(CTP paragraph, int index, T container) throws Exception {
        if (this.isWordDocumentPartParsing()) {
            this.masterPageManager.update(paragraph);
        }
        if (this.pageBreakOnNextParagraph) {
            this.pageBreak();
        }
        this.pageBreakOnNextParagraph = false;
        ListItemContext itemContext = null;
        T paragraphContainer = this.startVisitParagraph(paragraph, itemContext, container);
        this.visitParagraphBody(paragraph, index, paragraphContainer);
        this.endVisitParagraph(paragraph, container, paragraphContainer);
    }

    protected abstract void endVisitParagraph(CTP var1, T var2, T var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitParagraphBody(CTP paragraph, int index, T paragraphContainer) throws Exception {
        boolean fldCharTypeParsing = false;
        boolean pageNumber = false;
        String url = null;
        ArrayList<CTR> rListAfterSeparate = null;
        XmlCursor cursor = null;
        try {
            cursor = paragraph.newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o = cursor.getObject();
                if (o instanceof CTR) {
                    CTR r = (CTR)o;
                    STFldCharType.Enum fldCharType = XWPFRunHelper.getFldCharType(r);
                    if (fldCharType != null) {
                        if (fldCharType.equals(STFldCharType.BEGIN)) {
                            this.process(paragraph, paragraphContainer, pageNumber, url, (List<XmlObject>)rListAfterSeparate);
                            fldCharTypeParsing = true;
                            rListAfterSeparate = new ArrayList<CTR>();
                            pageNumber = false;
                            url = null;
                            continue;
                        }
                        if (!fldCharType.equals(STFldCharType.END)) continue;
                        this.process(paragraph, paragraphContainer, pageNumber, url, (List<XmlObject>)rListAfterSeparate);
                        fldCharTypeParsing = false;
                        rListAfterSeparate = null;
                        pageNumber = false;
                        url = null;
                        continue;
                    }
                    if (fldCharTypeParsing) {
                        String instrText = XWPFRunHelper.getInstrText(r);
                        if (instrText != null) {
                            if (!StringUtils.isNotEmpty(instrText)) continue;
                            boolean instrTextPage = XWPFRunHelper.isInstrTextPage(instrText);
                            if (!instrTextPage) {
                                String instrTextHyperlink = XWPFRunHelper.getInstrTextHyperlink(instrText);
                                if (instrTextHyperlink == null) continue;
                                url = instrTextHyperlink;
                                continue;
                            }
                            pageNumber = true;
                            continue;
                        }
                        rListAfterSeparate.add(r);
                        continue;
                    }
                    this.visitRun(r, paragraph, false, null, paragraphContainer);
                    continue;
                }
                if (fldCharTypeParsing) {
                    rListAfterSeparate.add((CTR)o);
                    continue;
                }
                this.visitRun(paragraph, o, paragraphContainer);
            }
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    private void process(CTP paragraph, T paragraphContainer, boolean pageNumber, String url, List<XmlObject> rListAfterSeparate) throws Exception {
        if (rListAfterSeparate != null) {
            for (XmlObject oAfterSeparate : rListAfterSeparate) {
                if (oAfterSeparate instanceof CTR) {
                    CTR ctr = (CTR)oAfterSeparate;
                    this.visitRun(ctr, paragraph, pageNumber, url, paragraphContainer);
                    continue;
                }
                this.visitRun(paragraph, oAfterSeparate, paragraphContainer);
            }
        }
    }

    private void visitRun(CTP paragraph, XmlObject o, T paragraphContainer) throws Exception {
        if (o instanceof CTHyperlink) {
            CTHyperlink link = (CTHyperlink)o;
            String anchor = link.getAnchor();
            String href = null;
            String hyperlinkId = link.getId();
            if (StringUtils.isNotEmpty(hyperlinkId)) {
                // empty if block
            }
            for (CTR r : link.getRList()) {
                this.visitRun(r, paragraph, false, href != null ? href : "#" + anchor, paragraphContainer);
            }
        } else if (o instanceof CTSdtRun) {
            CTSdtContentRun run = ((CTSdtRun)o).getSdtContent();
            for (CTR r : run.getRList()) {
                this.visitRun(r, paragraph, false, null, paragraphContainer);
            }
        } else if (o instanceof CTRunTrackChange) {
            for (CTR r : ((CTRunTrackChange)o).getRList()) {
                this.visitRun(r, paragraph, false, null, paragraphContainer);
            }
        } else if (o instanceof CTSimpleField) {
            CTSimpleField simpleField = (CTSimpleField)o;
            String instr = simpleField.getInstr();
            boolean fieldPageNumber = XWPFRunHelper.isInstrTextPage(instr);
            String fieldHref = null;
            if (!fieldPageNumber) {
                fieldHref = XWPFRunHelper.getInstrTextHyperlink(instr);
            }
            for (CTR r : simpleField.getRList()) {
                this.visitRun(r, paragraph, fieldPageNumber, fieldHref, paragraphContainer);
            }
        } else if (!(o instanceof CTSmartTagRun) && o instanceof CTBookmark) {
            CTBookmark bookmark = (CTBookmark)o;
            this.visitBookmark(bookmark, paragraph, paragraphContainer);
        }
    }

    protected abstract T startVisitParagraph(CTP var1, ListItemContext var2, T var3) throws Exception;

    protected abstract void pageBreak() throws Exception;

    protected void visitRun(CTR run, CTP paragraph, boolean pageNumber, String url, T paragraphContainer) throws Exception {
        XmlCursor c = run.newCursor();
        c.selectPath("./*");
        while (c.toNextSelection()) {
            XmlObject o = c.getObject();
            if (o instanceof CTText) {
                CTText ctText = (CTText)o;
                String tagName = o.getDomNode().getNodeName();
                if ("w:instrText".equals(tagName)) continue;
                this.visitText(ctText, pageNumber, paragraphContainer);
                continue;
            }
            if (o instanceof CTPTab) {
                this.visitTab((CTPTab)o, paragraphContainer);
                continue;
            }
            if (o instanceof CTBr) {
                this.visitBR((CTBr)o, paragraphContainer);
                continue;
            }
            if (o instanceof CTEmpty) {
                String tagName = o.getDomNode().getNodeName();
                if ("w:tab".equals(tagName)) {
                    CTTabs tabs = null;
                    this.visitTabs(tabs, paragraphContainer);
                }
                if ("w:br".equals(tagName)) {
                    this.visitBR(null, paragraphContainer);
                }
                if (!"w:cr".equals(tagName)) continue;
                this.visitBR(null, paragraphContainer);
                continue;
            }
            if (!(o instanceof CTDrawing)) continue;
            this.visitDrawing((CTDrawing)o, paragraphContainer);
        }
        c.dispose();
    }

    protected abstract void visitText(CTText var1, boolean var2, T var3) throws Exception;

    protected abstract void visitTab(CTPTab var1, T var2) throws Exception;

    protected abstract void visitTabs(CTTabs var1, T var2) throws Exception;

    protected void visitBR(CTBr br, T paragraphContainer) throws Exception {
        STBrType.Enum brType = XWPFRunHelper.getBrType(br);
        if (brType.equals(STBrType.PAGE)) {
            this.pageBreakOnNextParagraph = true;
        } else {
            this.addNewLine(br, paragraphContainer);
        }
    }

    protected abstract void visitBookmark(CTBookmark var1, CTP var2, T var3) throws Exception;

    protected abstract void addNewLine(CTBr var1, T var2) throws Exception;

    protected void visitTable(CTTbl table, int i, T container) throws Exception {
        this.tables.push(table);
        float[] colWidths = XWPFTableUtil.computeColWidths(table);
        T tableContainer = this.startVisitTable(table, colWidths, container);
        this.visitTableBody(table, colWidths, tableContainer);
        this.endVisitTable(table, container, tableContainer);
        this.tables.pop();
    }

    protected abstract T startVisitTable(CTTbl var1, float[] var2, T var3) throws Exception;

    protected abstract void endVisitTable(CTTbl var1, T var2, T var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitTableBody(CTTbl table, float[] colWidths, T tableContainer) throws Exception {
        XmlCursor cursor = null;
        try {
            cursor = table.newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o = cursor.getObject();
                if (!(o instanceof CTRow)) continue;
                this.visitTableRow((CTRow)o, tableContainer);
            }
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitTableRow(CTRow row, T tableContainer) throws Exception {
        boolean headerRow = this.stylesDocument.isTableRowHeader(row);
        this.startVisitTableRow(row, tableContainer, headerRow);
        XmlCursor cursor = null;
        try {
            cursor = row.newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o = cursor.getObject();
                if (!(o instanceof CTTc)) continue;
                if (o instanceof CTTc) {
                    CTTc cell = (CTTc)o;
                    this.visitCell(cell, tableContainer);
                    continue;
                }
                if (!(o instanceof CTSdtCell)) continue;
                CTSdtCell sdtCell = (CTSdtCell)o;
                List<CTTc> tcList = sdtCell.getSdtContent().getTcList();
                for (CTTc cell : tcList) {
                    this.visitCell(cell, tableContainer);
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    protected abstract void startVisitTableRow(CTRow var1, T var2, boolean var3) throws Exception;

    protected void visitCell(CTTc cell, T tableContainer) throws Exception {
        T tableCellContainer = this.startVisitTableCell(cell, tableContainer);
        this.visitTableCellBody(cell, tableCellContainer);
        this.endVisitTableCell(cell, tableContainer, tableCellContainer);
    }

    protected abstract T startVisitTableCell(CTTc var1, T var2) throws Exception;

    protected void visitTableCellBody(CTTc cell, T tableCellContainer) throws Exception {
        this.visitBodyElements(cell, tableCellContainer);
    }

    protected abstract void endVisitTableCell(CTTc var1, T var2, T var3) throws Exception;

    protected void visitDrawing(CTDrawing drawing, T parentContainer) throws Exception {
        List<CTInline> inlines = drawing.getInlineList();
        for (CTInline inline : inlines) {
            this.visitInline(inline, parentContainer);
        }
        List<CTAnchor> anchors = drawing.getAnchorList();
        for (CTAnchor anchor : anchors) {
            this.visitAnchor(anchor, parentContainer);
        }
    }

    protected void visitAnchor(CTAnchor anchor, T parentContainer) throws Exception {
        CTGraphicalObject graphic = anchor.getGraphic();
        STRelFromH.Enum relativeFromH = null;
        Float offsetX = null;
        CTPosH positionH = anchor.getPositionH();
        if (positionH != null) {
            relativeFromH = positionH.getRelativeFrom();
        }
        STRelFromV.Enum relativeFromV = null;
        Float offsetY = null;
        CTPosV positionV = anchor.getPositionV();
        if (positionV != null) {
            relativeFromV = positionV.getRelativeFrom();
            offsetY = Float.valueOf(DxaUtil.emu2points(positionV.getPosOffset()));
        }
        STWrapText.Enum wrapText = null;
        CTWrapSquare wrapSquare = anchor.getWrapSquare();
        if (wrapSquare != null) {
            wrapText = wrapSquare.getWrapText();
        }
        this.visitGraphicalObject(parentContainer, graphic, offsetX, relativeFromH, offsetY, relativeFromV, wrapText);
    }

    protected void visitInline(CTInline inline, T parentContainer) throws Exception {
        CTGraphicalObject graphic = inline.getGraphic();
        this.visitGraphicalObject(parentContainer, graphic, null, null, null, null, null);
    }

    private void visitGraphicalObject(T parentContainer, CTGraphicalObject graphic, Float offsetX, STRelFromH.Enum relativeFromH, Float offsetY, STRelFromV.Enum relativeFromV, STWrapText.Enum wrapText) throws Exception {
        CTGraphicalObjectData graphicData;
        if (graphic != null && (graphicData = graphic.getGraphicData()) != null) {
            XmlCursor c = graphicData.newCursor();
            c.selectPath("./*");
            while (c.toNextSelection()) {
                XmlObject o = c.getObject();
                if (!(o instanceof CTPicture)) continue;
                CTPicture picture = (CTPicture)o;
                IImageExtractor extractor = this.getImageExtractor();
                if (extractor != null) {
                    // empty if block
                }
                this.visitPicture(picture, offsetX, relativeFromH, offsetY, relativeFromV, wrapText, parentContainer);
            }
            c.dispose();
        }
    }

    protected abstract void visitPicture(CTPicture var1, Float var2, STRelFromH.Enum var3, Float var4, STRelFromV.Enum var5, STWrapText.Enum var6, T var7) throws Exception;

    @Override
    public void visitHeaderRef(CTHdrFtrRef headerRef, CTSectPr sectPr, E masterPage) throws Exception {
        this.currentHeaderRef = headerRef;
        this.currentHeader = this.getHeader(headerRef);
        this.visitHeader(this.currentHeader, headerRef, sectPr, masterPage);
        this.currentHeader = null;
        this.currentHeaderRef = null;
    }

    protected abstract void visitHeader(CTHdrFtr var1, CTHdrFtrRef var2, CTSectPr var3, E var4) throws Exception;

    private CTHdrFtr getHeader(CTHdrFtrRef headerRef) throws Exception {
        String relId = headerRef.getId();
        HdrDocument hdrDoc = this.provider.getHdrDocumentByPartId(relId);
        CTHdrFtr hdrFtr = hdrDoc.getHdr();
        return hdrFtr;
    }

    @Override
    public void visitFooterRef(CTHdrFtrRef footerRef, CTSectPr sectPr, E masterPage) throws Exception {
        this.currentFooterRef = footerRef;
        this.currentFooter = this.getFooter(footerRef);
        this.visitFooter(this.currentFooter, footerRef, sectPr, masterPage);
        this.currentFooter = null;
        this.currentFooterRef = null;
    }

    protected abstract void visitFooter(CTHdrFtr var1, CTHdrFtrRef var2, CTSectPr var3, E var4) throws Exception;

    private CTHdrFtr getFooter(CTHdrFtrRef footerRef) throws Exception {
        String relId = footerRef.getId();
        FtrDocument hdrDoc = this.provider.getFtrDocumentByPartId(relId);
        CTHdrFtr hdrFtr = hdrDoc.getFtr();
        return hdrFtr;
    }

    protected IImageExtractor getImageExtractor() {
        return ((Options)this.options).getExtractor();
    }

    protected boolean isWordDocumentPartParsing() {
        return this.currentHeader == null && this.currentFooter == null;
    }

    public CTTbl getParentTable() {
        if (this.tables.isEmpty()) {
            return null;
        }
        return this.tables.peek();
    }

    public byte[] getPictureBytes(CTPicture picture) throws Exception {
        CTBlipFillProperties blipProps = picture.getBlipFill();
        if (blipProps == null || !blipProps.isSetBlip()) {
            return null;
        }
        String blipId = blipProps.getBlip().getEmbed();
        InputStream in = this.provider.getInputStreamByRelId(this.getPartRelIdParsing(), blipId);
        if (in == null) {
            return null;
        }
        return IOUtils.toByteArray(in);
    }

    private String getPartRelIdParsing() {
        if (this.currentHeaderRef != null) {
            return this.currentHeaderRef.getId();
        }
        if (this.currentFooterRef != null) {
            return this.currentFooterRef.getId();
        }
        return null;
    }
}

