/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.openxmlformats.styles.table;

import org.apache.poi.xwpf.converter.core.openxmlformats.styles.table.AbstractTableValueProvider;
import org.apache.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import org.apache.poi.xwpf.converter.core.utils.DxaUtil;
import org.apache.poi.xwpf.converter.core.utils.XWPFTableUtil;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableIndentationValueProvider
extends AbstractTableValueProvider<Float> {
    public static final TableIndentationValueProvider INSTANCE = new TableIndentationValueProvider();

    @Override
    public Float getValue(CTTblPr tblPr, XWPFStylesDocument document) {
        return this.getTableAlignment(tblPr);
    }

    @Override
    public Float getValue(CTTblPrBase tblPr, XWPFStylesDocument document) {
        return this.getTableAlignment(tblPr);
    }

    private Float getTableAlignment(CTTblPrBase tblPr) {
        if (tblPr == null) {
            return null;
        }
        CTTblWidth tblWidth = tblPr.getTblInd();
        if (tblWidth != null) {
            Float width;
            STTblWidth.Enum type = tblWidth.getType();
            if (type != null) {
                // empty if block
            }
            if ((width = XWPFTableUtil.getTblWidthW(tblWidth)) != null) {
                return Float.valueOf(DxaUtil.dxa2points(width.floatValue()));
            }
        }
        return null;
    }
}

