/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldriscoll.ektorplucene;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.ldriscoll.ektorplucene.CustomLuceneResult;
import com.github.ldriscoll.ektorplucene.EktorpLuceneObjectMapperFactory;
import com.github.ldriscoll.ektorplucene.LuceneQuery;
import com.github.ldriscoll.ektorplucene.LuceneResult;
import java.io.IOException;
import org.ektorp.CouchDbInstance;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.http.URI;
import org.ektorp.impl.ObjectMapperFactory;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.util.Assert;

public class LuceneAwareCouchDbConnector
extends StdCouchDbConnector {
    public static String DEFAULT_LUCENE_PREFIX = "_fti";
    public static String DEFAULT_LUCENE_INDEX = "local";
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final String lucenePrefix;
    private final String luceneIndex;
    private final String dbName;

    public LuceneAwareCouchDbConnector(String databaseName, CouchDbInstance dbInstance) throws IOException {
        super(databaseName, dbInstance, (ObjectMapperFactory)new EktorpLuceneObjectMapperFactory());
        this.dbName = databaseName;
        this.restTemplate = new RestTemplate(dbInstance.getConnection());
        this.objectMapper = new EktorpLuceneObjectMapperFactory().createObjectMapper();
        HttpResponse response = dbInstance.getConnection().get("/");
        JsonNode node = (JsonNode)this.objectMapper.readValue(response.getContent(), JsonNode.class);
        String version = node.get("version").asText();
        if (version.startsWith("0.") || version.startsWith("1.0")) {
            this.lucenePrefix = DEFAULT_LUCENE_PREFIX;
            this.luceneIndex = null;
        } else {
            this.lucenePrefix = DEFAULT_LUCENE_PREFIX;
            this.luceneIndex = DEFAULT_LUCENE_INDEX;
        }
    }

    public LuceneAwareCouchDbConnector(String databaseName, CouchDbInstance dbInstance, String lucenePrefix, String luceneIndex) {
        super(databaseName, dbInstance, (ObjectMapperFactory)new EktorpLuceneObjectMapperFactory());
        this.dbName = databaseName;
        this.restTemplate = new RestTemplate(dbInstance.getConnection());
        this.objectMapper = new EktorpLuceneObjectMapperFactory().createObjectMapper();
        this.lucenePrefix = lucenePrefix;
        this.luceneIndex = luceneIndex;
    }

    private URI buildIndexRoot() {
        URI uri;
        if (this.luceneIndex != null) {
            uri = URI.of((String)("/" + this.lucenePrefix));
            uri.append(this.luceneIndex);
            uri.append(this.dbName);
        } else {
            uri = URI.of((String)this.path());
            uri.append(this.lucenePrefix);
        }
        return uri;
    }

    public LuceneResult queryLucene(LuceneQuery query) {
        Assert.notNull((Object)query, (String)"query cannot be null");
        StdResponseHandler<LuceneResult> rh = new StdResponseHandler<LuceneResult>(){

            public LuceneResult success(HttpResponse hr) throws Exception {
                return (LuceneResult)LuceneAwareCouchDbConnector.this.objectMapper.readValue(hr.getContent(), LuceneResult.class);
            }
        };
        return (LuceneResult)this.restTemplate.get(query.buildQuery(this.buildIndexRoot()), (ResponseCallback)rh);
    }

    public CustomLuceneResult queryLucene(LuceneQuery query, final TypeReference type) {
        Assert.notNull((Object)query, (String)"query cannot be null");
        StdResponseHandler<CustomLuceneResult> rh = new StdResponseHandler<CustomLuceneResult>(){

            public CustomLuceneResult success(HttpResponse hr) throws Exception {
                return (CustomLuceneResult)LuceneAwareCouchDbConnector.this.objectMapper.readValue(hr.getContent(), type);
            }
        };
        return (CustomLuceneResult)this.restTemplate.get(query.buildQuery(this.buildIndexRoot()), (ResponseCallback)rh);
    }
}

