/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldriscoll.ektorplucene;

import org.apache.commons.lang.StringUtils;
import org.ektorp.http.URI;

public class LuceneQuery {
    private String analyzer;
    private String callback;
    private Boolean debug;
    private Operator defaultOperator;
    private Boolean forceJSON;
    private Boolean includeDocs;
    private Integer limit;
    private String query;
    private Integer skip;
    private String sort;
    private Boolean staleOk;
    private String cachedQuery;
    private final String designDocument;
    private final String indexFunction;

    public LuceneQuery(String designDocument, String indexFunction) {
        this.designDocument = designDocument.startsWith("_design/") ? designDocument : "_design/" + designDocument;
        this.indexFunction = indexFunction;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public void setDefaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    public void setForceJSON(Boolean forceJSON) {
        this.forceJSON = forceJSON;
    }

    public void setIncludeDocs(Boolean includeDocs) {
        this.includeDocs = includeDocs;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setSkip(Integer skip) {
        this.skip = skip;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setStaleOk(Boolean staleOk) {
        this.staleOk = staleOk;
    }

    private boolean hasValue(Object o) {
        if (o instanceof String) {
            return !StringUtils.isEmpty((String)((String)o));
        }
        return o != null;
    }

    private void addParam(URI query, String paramName, Object value) {
        if (this.hasValue(value)) {
            query.param(paramName, value.toString());
        }
    }

    String buildQuery(URI query) {
        if (this.cachedQuery != null) {
            return this.cachedQuery;
        }
        System.out.println(this.designDocument + " " + this.indexFunction);
        query.append(this.designDocument);
        query.append(this.indexFunction);
        this.addParam(query, "analyzer", this.analyzer);
        this.addParam(query, "callback", this.callback);
        this.addParam(query, "debug", this.debug);
        this.addParam(query, "default_operator", (Object)this.defaultOperator);
        this.addParam(query, "force_json", this.forceJSON);
        this.addParam(query, "include_docs", this.includeDocs);
        this.addParam(query, "limit", this.limit);
        this.addParam(query, "q", this.query);
        this.addParam(query, "skip", this.skip);
        this.addParam(query, "sort", this.sort);
        if (this.staleOk != null && this.staleOk.booleanValue()) {
            query.param("stale", "ok");
        }
        this.cachedQuery = query.toString();
        return this.cachedQuery;
    }

    public void reset() {
        this.cachedQuery = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneQuery that = (LuceneQuery)o;
        if (this.analyzer != null ? !this.analyzer.equals(that.analyzer) : that.analyzer != null) {
            return false;
        }
        if (this.callback != null ? !this.callback.equals(that.callback) : that.callback != null) {
            return false;
        }
        if (this.debug != null ? !this.debug.equals(that.debug) : that.debug != null) {
            return false;
        }
        if (this.defaultOperator != that.defaultOperator) {
            return false;
        }
        if (this.forceJSON != null ? !this.forceJSON.equals(that.forceJSON) : that.forceJSON != null) {
            return false;
        }
        if (this.includeDocs != null ? !this.includeDocs.equals(that.includeDocs) : that.includeDocs != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        if (this.skip != null ? !this.skip.equals(that.skip) : that.skip != null) {
            return false;
        }
        if (this.sort != null ? !this.sort.equals(that.sort) : that.sort != null) {
            return false;
        }
        return !(this.staleOk != null ? !this.staleOk.equals(that.staleOk) : that.staleOk != null);
    }

    public int hashCode() {
        int result = this.analyzer != null ? this.analyzer.hashCode() : 0;
        result = 31 * result + (this.callback != null ? this.callback.hashCode() : 0);
        result = 31 * result + (this.debug != null ? this.debug.hashCode() : 0);
        result = 31 * result + (this.defaultOperator != null ? this.defaultOperator.hashCode() : 0);
        result = 31 * result + (this.forceJSON != null ? this.forceJSON.hashCode() : 0);
        result = 31 * result + (this.includeDocs != null ? this.includeDocs.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        result = 31 * result + (this.skip != null ? this.skip.hashCode() : 0);
        result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
        result = 31 * result + (this.staleOk != null ? this.staleOk.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        OR,
        AND;

    }
}

