/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldriscoll.ektorplucene.designdocument;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.ldriscoll.ektorplucene.designdocument.LuceneIndex;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ektorp.support.DesignDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneDesignDocument
extends DesignDocument {
    private static final long serialVersionUID = 5232811585073232156L;
    private Map<String, LuceneIndex> indexes;

    public LuceneDesignDocument() {
    }

    public LuceneDesignDocument(String id) {
        super(id);
    }

    @JsonProperty
    public Map<String, LuceneIndex> getFulltext() {
        return Collections.unmodifiableMap(this.indexes());
    }

    @JsonProperty
    void setFulltext(Map<String, LuceneIndex> indexes) {
        this.indexes = indexes;
    }

    private Map<String, LuceneIndex> indexes() {
        if (this.indexes == null) {
            this.indexes = new HashMap<String, LuceneIndex>();
        }
        return this.indexes;
    }

    public boolean containsIndex(String name) {
        return this.indexes().containsKey(name);
    }

    public LuceneIndex getIndex(String indexName) {
        return this.indexes().get(indexName);
    }

    public void addIndex(String name, LuceneIndex i) {
        this.indexes().put(name, i);
    }

    public void removeIndex(String name) {
        this.indexes().remove(name);
    }

    public boolean mergeWith(DesignDocument dd) {
        boolean changed = super.mergeWith(dd);
        if (dd instanceof LuceneDesignDocument) {
            boolean updateOnDiff = this.updateOnDiff();
            changed = this.mergeIndexes(((LuceneDesignDocument)dd).indexes(), updateOnDiff) || changed;
        }
        return changed;
    }

    private boolean mergeIndexes(Map<String, LuceneIndex> mergeIndexes, boolean updateOnDiff) {
        boolean changed = false;
        for (Map.Entry<String, LuceneIndex> e : mergeIndexes.entrySet()) {
            LuceneIndex existing;
            String name = e.getKey();
            LuceneIndex candidate = e.getValue();
            if (!this.containsIndex(name)) {
                this.addIndex(name, candidate);
                changed = true;
                continue;
            }
            if (!updateOnDiff || (existing = this.getIndex(name)).equals(candidate)) continue;
            this.addIndex(name, candidate);
            changed = true;
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String existingIndexName : this.indexes().keySet()) {
            if (mergeIndexes.containsKey(existingIndexName)) continue;
            toRemove.add(existingIndexName);
            changed = true;
        }
        for (String removeIndexName : toRemove) {
            this.removeIndex(removeIndexName);
        }
        return changed;
    }

    private boolean updateOnDiff() {
        return Boolean.getBoolean("org.ektorp.support.AutoUpdateViewOnChange") || Boolean.getBoolean("org.ektorp.support.UpdateDesignDocOnDiff");
    }
}

