/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldriscoll.ektorplucene.designdocument;

import com.github.ldriscoll.ektorplucene.designdocument.LuceneDesignDocument;
import com.github.ldriscoll.ektorplucene.designdocument.LuceneIndex;
import com.github.ldriscoll.ektorplucene.designdocument.annotation.FullText;
import com.github.ldriscoll.ektorplucene.designdocument.annotation.Index;
import java.util.HashMap;
import java.util.Map;
import org.ektorp.support.DesignDocument;
import org.ektorp.support.StdDesignDocumentFactory;
import org.ektorp.util.Predicate;
import org.ektorp.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneDesignDocumentFactory
extends StdDesignDocumentFactory {
    public LuceneDesignDocument generateFrom(Object metaDataSource) {
        LuceneDesignDocument dd = (LuceneDesignDocument)super.generateFrom(metaDataSource);
        Class<?> metaDataClass = metaDataSource.getClass();
        Map<String, LuceneIndex> indexes = this.createIndexes(metaDataClass);
        dd.setFulltext(indexes);
        return dd;
    }

    private Map<String, LuceneIndex> createIndexes(Class<?> metaDataClass) {
        final HashMap<String, LuceneIndex> indexes = new HashMap<String, LuceneIndex>();
        ReflectionUtils.eachAnnotation(metaDataClass, FullText.class, (Predicate)new Predicate<FullText>(){

            public boolean apply(FullText input) {
                for (Index idx : input.value()) {
                    indexes.put(idx.name(), LuceneIndex.fromAnnotation(idx));
                }
                return true;
            }
        });
        return indexes;
    }

    public DesignDocument newDesignDocumentInstance() {
        return new LuceneDesignDocument();
    }
}

