/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldriscoll.ektorplucene.designdocument;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.ldriscoll.ektorplucene.designdocument.LuceneDefaults;
import com.github.ldriscoll.ektorplucene.designdocument.annotation.Index;
import org.apache.commons.lang.StringUtils;
import org.ektorp.util.Assert;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class LuceneIndex {
    @JsonProperty
    private String index;
    @JsonProperty
    private LuceneDefaults defaults;
    @JsonProperty
    private String analyzer;

    public static LuceneIndex fromAnnotation(Index idx) {
        Assert.hasText((String)idx.index(), (String)"The index function can't be null or empty");
        LuceneIndex li = new LuceneIndex();
        li.setIndex(idx.index());
        li.setDefaults(LuceneDefaults.fromAnnotation(idx.defaults()));
        if (!StringUtils.isBlank((String)idx.analyzer())) {
            li.setAnalyzer(idx.analyzer());
        }
        return li;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public LuceneDefaults getDefaults() {
        return this.defaults;
    }

    public void setDefaults(LuceneDefaults defaults) {
        this.defaults = defaults;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.defaults == null ? 0 : this.defaults.hashCode());
        result = 31 * result + (this.analyzer == null ? 0 : this.analyzer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LuceneIndex other = (LuceneIndex)obj;
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.defaults == null ? other.defaults != null : !this.defaults.equals(other.defaults)) {
            return false;
        }
        return !(this.analyzer == null ? other.analyzer != null : !this.analyzer.equals(other.analyzer));
    }
}

