/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldriscoll.ektorplucene.util;

import java.util.HashMap;
import java.util.zip.CRC32;
import org.ektorp.CouchDbConnector;
import org.ektorp.support.DesignDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexUploader {
    private final Logger log = LoggerFactory.getLogger(IndexUploader.class);
    private static final String CHECKSUM_SUFFIX = "_checksum";

    public boolean updateSearchFunctionIfNecessary(CouchDbConnector db, String viewName, String searchFunction, String javascriptIndexFunctionBody) {
        boolean updatePerformed = false;
        String designDocName = viewName.startsWith("_design/") ? viewName : "_design/" + viewName;
        CRC32 chk = new CRC32();
        byte[] bytes = javascriptIndexFunctionBody.getBytes();
        chk.update(bytes, 0, bytes.length);
        long actualChk = chk.getValue();
        if (!db.contains(designDocName)) {
            DesignDocument doc = new DesignDocument(designDocName);
            db.create((Object)doc);
            this.updateSearchFunction(db, doc, searchFunction, javascriptIndexFunctionBody, actualChk);
            updatePerformed = true;
        } else {
            DesignDocument doc = (DesignDocument)db.get(DesignDocument.class, designDocName);
            Number docChk = (Number)doc.getAnonymous().get(this.getChecksumFieldName(searchFunction));
            if (docChk == null || docChk.longValue() != actualChk) {
                this.log.info("Updating the index function");
                this.updateSearchFunction(db, doc, searchFunction, javascriptIndexFunctionBody, actualChk);
                updatePerformed = true;
            }
        }
        return updatePerformed;
    }

    private String getChecksumFieldName(String searchFunction) {
        return searchFunction + CHECKSUM_SUFFIX;
    }

    private void updateSearchFunction(CouchDbConnector db, DesignDocument doc, String searchFunctionName, String javascript, long jsChecksum) {
        HashMap<String, String> searchObject;
        HashMap<String, HashMap<String, String>> fullText = (HashMap<String, HashMap<String, String>>)doc.getAnonymous().get("fulltext");
        if (fullText == null) {
            fullText = new HashMap<String, HashMap<String, String>>();
            doc.setAnonymous("fulltext", fullText);
        }
        if ((searchObject = (HashMap<String, String>)fullText.get(searchFunctionName)) == null) {
            searchObject = new HashMap<String, String>();
            fullText.put(searchFunctionName, searchObject);
        }
        searchObject.put("index", javascript);
        doc.setAnonymous(this.getChecksumFieldName(searchFunctionName), (Object)jsChecksum);
        db.update((Object)doc);
    }
}

