/*
 * Decompiled with CFR 0.152.
 */
package com.github.leonardoxh.keystore;

import android.content.Context;
import android.util.Base64;
import javax.annotation.Nullable;

final class CipherPreferencesStorage {
    private static final String SHARED_PREFERENCES_NAME = "security_storage";

    private CipherPreferencesStorage() {
        throw new AssertionError();
    }

    private static void saveKeyString(Context context, String alias, String value) {
        context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0).edit().putString(alias, value).apply();
    }

    static void remove(Context context, String alias) {
        context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0).edit().remove(alias).apply();
    }

    static boolean containsAlias(Context context, String alias) {
        return context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0).contains(alias);
    }

    @Nullable
    private static String getKeyString(Context context, String alias) {
        return context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0).getString(alias, null);
    }

    @Nullable
    static byte[] getKeyBytes(Context context, String alias) {
        String value = CipherPreferencesStorage.getKeyString(context, alias);
        if (value != null) {
            return Base64.decode((String)value, (int)0);
        }
        return null;
    }

    static void saveKeyBytes(Context context, String alias, byte[] value) {
        CipherPreferencesStorage.saveKeyString(context, alias, Base64.encodeToString((byte[])value, (int)0));
    }
}

