/*
 * Decompiled with CFR 0.152.
 */
package com.github.leonardoxh.keystore;

import android.annotation.TargetApi;
import android.content.Context;
import android.security.KeyPairGeneratorSpec;
import com.github.leonardoxh.keystore.CipherPreferencesStorage;
import com.github.leonardoxh.keystore.CipherStorage;
import com.github.leonardoxh.keystore.CryptoFailedException;
import com.github.leonardoxh.keystore.KeyStoreAccessException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.GregorianCalendar;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

@TargetApi(value=22)
class CipherStorageSharedPreferencesKeystore
implements CipherStorage {
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    private static final String KEY_ALGORITHM_RSA = "RSA";
    private static final String KEY_ALGORITHM_AES = "AES";
    private static final String TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    private static final int ENCRYPTION_KEY_SIZE = 128;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final BigInteger KEY_SERIAL_NUMBER = BigInteger.valueOf(1338L);
    private final Context context;

    CipherStorageSharedPreferencesKeystore(Context context) {
        this.context = context;
    }

    @Override
    public void encrypt(String alias, String value) {
        KeyStore.Entry entry = this.getKeyStoreEntry(true, alias);
        if (entry == null) {
            throw new CryptoFailedException("Unable to generate key for alias " + alias);
        }
        KeyStore.PrivateKeyEntry key = (KeyStore.PrivateKeyEntry)entry;
        byte[] encryptedData = this.encryptData(alias, value, key.getCertificate().getPublicKey());
        CipherPreferencesStorage.saveKeyBytes(this.context, alias, encryptedData);
    }

    @Override
    @Nullable
    public String decrypt(String alias) {
        KeyStore.Entry entry = this.getKeyStoreEntry(false, alias);
        if (entry == null) {
            return null;
        }
        KeyStore.PrivateKeyEntry key = (KeyStore.PrivateKeyEntry)entry;
        return this.decryptData(alias, key.getPrivateKey());
    }

    @Override
    public boolean containsAlias(String alias) {
        return CipherPreferencesStorage.containsAlias(this.context, alias);
    }

    @Override
    public void removeKey(String alias) {
        CipherPreferencesStorage.remove(this.context, alias);
    }

    @Override
    public void saveOrReplace(String alias, String value) {
        if (this.containsAlias(alias)) {
            this.removeKey(alias);
        }
        this.encrypt(alias, value);
    }

    @Nullable
    private String decryptData(String alias, PrivateKey privateKey) {
        byte[] encryptedData = CipherPreferencesStorage.getKeyBytes(this.context, alias);
        byte[] secretData = CipherPreferencesStorage.getKeyBytes(this.context, "aes!" + alias);
        if (encryptedData == null || secretData == null) {
            return null;
        }
        byte[] decryptedData = CipherStorageSharedPreferencesKeystore.decryptRsa(secretData, privateKey);
        SecretKeySpec secretKey = new SecretKeySpec(decryptedData, 0, decryptedData.length, KEY_ALGORITHM_AES);
        byte[] finalData = CipherStorageSharedPreferencesKeystore.decryptAes(encryptedData, secretKey);
        return new String(finalData, DEFAULT_CHARSET);
    }

    private static byte[] decryptAes(byte[] decryptedKey, SecretKey secret) {
        try {
            Cipher cipherAes = Cipher.getInstance(KEY_ALGORITHM_AES);
            cipherAes.init(2, secret);
            return cipherAes.doFinal(decryptedKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoFailedException("Unable to decrypt key AES", e);
        }
    }

    private static byte[] decryptRsa(byte[] inputByteArray, PrivateKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, secretKey);
            return cipher.doFinal(inputByteArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoFailedException("Unable to decrypt key RSA", e);
        }
    }

    private void generateKeyRsa(String alias) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA, ANDROID_KEY_STORE);
            keyPairGenerator.initialize(this.getParameterSpec(alias));
            keyPairGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new KeyStoreAccessException("Unable to access keystore", e);
        }
    }

    private AlgorithmParameterSpec getParameterSpec(String alias) {
        GregorianCalendar start = new GregorianCalendar();
        GregorianCalendar end = new GregorianCalendar();
        end.add(1, 5);
        return new KeyPairGeneratorSpec.Builder(this.context).setAlias(alias).setSubject(new X500Principal("CN=" + alias)).setSerialNumber(KEY_SERIAL_NUMBER).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
    }

    @Nullable
    private KeyStore.Entry getKeyStoreEntry(boolean shouldGenerateKey, String alias) {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
            keyStore.load(null);
            KeyStore.Entry entry = keyStore.getEntry(alias, null);
            if (entry == null && shouldGenerateKey) {
                this.generateKeyRsa(alias);
                entry = keyStore.getEntry(alias, null);
            }
            return entry;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
            throw new KeyStoreAccessException("Unable to access keystore", e);
        }
    }

    private byte[] encryptData(String alias, String value, PublicKey publicKey) {
        SecretKey secret = this.generateKeyAes(alias);
        CipherPreferencesStorage.saveKeyBytes(this.context, "aes!" + alias, CipherStorageSharedPreferencesKeystore.encryptRsa(secret.getEncoded(), publicKey));
        return this.encryptAes(alias, value, secret);
    }

    private byte[] encryptAes(String alias, String value, SecretKey secret) {
        try {
            Cipher cipherAes = Cipher.getInstance(KEY_ALGORITHM_AES);
            cipherAes.init(1, secret);
            return cipherAes.doFinal(value.getBytes(DEFAULT_CHARSET));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoFailedException("Unable to encrypt key aes for alias " + alias, e);
        }
    }

    private SecretKey generateKeyAes(String alias) {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(KEY_ALGORITHM_AES);
            generator.init(128);
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoFailedException("Unable to generate key for alias " + alias, e);
        }
    }

    private static byte[] encryptRsa(byte[] inputByteArray, PublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, publicKey);
            return cipher.doFinal(inputByteArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoFailedException("Unable to encrypt RSA", e);
        }
    }
}

